function [x, f] = f_prox_l1(Y, rho)
% f_prox_l1  Compute the proximal operator of the l1-norm
% 
%   Solves: x = argmin_z { 0.5 * ||z - Y||_F^2 + rho * ||z||_1 }
%
%   Inputs:
%       Y   - Input tensor (can be real-valued or complex, any size)
%       rho - Regularization parameter (positive scalar)
%
%   Outputs:
%       x   - Result of soft-thresholding (proximal mapping)
%       f   - l1-norm of the result (used for monitoring / dual update)

% Convert input to double precision
Y = double(Y);

% Apply soft-thresholding elementwise
x = sign(Y) .* max(abs(Y) - rho, 0);

% Compute the l1-norm of the output
f = sum(abs(x(:)));
end
