# 📐 Bidirectional Tensor Representation (BTR): Geometry-Inspired Examples

This repository provides **illustrative examples** of the **Bidirectional Tensor Representation (BTR)** framework, a modeling approach inspired by the **t-product geometry of tensor data**.

## 🧠 Geometric Motivation

The BTR framework is grounded in the t-product geometry, which are characterized by directional substructures known as t-modules defined over the t-product algebra. Specifically, BTR enforces simultaneous low-rankness in both the row-wise module $\mathbb{K}_w^h$ and the column-wise module $\mathbb{K}_h^w$, thereby aligning the representation with the intrinsic bi-module structure of t-manifolds. This dual constraint induces a geometric coupling between orthogonal directions, effectively bending the ambient tensor space away from flatness. As a result, BTR embodies a non-Euclidean constraint that captures multi-directional coherence, offering a more expressive and geometrically faithful prior for tensor representation.

## 📁 Folder Overview

```
.
├── BTR4LRR/               # Example: Unsupervised clustering using dual-mode affinity
│                         # (on PIE_face_10 data, with spectral clustering)
│
├── BTR4TensorRecovery/    # Example: Poisson tensor recovery using BTR-TNN model
│                         # (on Indian Pines data, with transform-domain ADMM solver)
```

Each folder contains a minimal example to demonstrate how BTR geometry can be applied in practice.

## 💡 What These Examples Show

- How **dual low-rank constraints** define a structured geometric space for tensors
- How to implement **t-product-based modeling** in both the row and column directions
- How such geometry-aware modeling improves robustness and representation

## 📎 Disclaimer

These are **prototype scripts** intended for demonstration and experimental illustration. They are not optimized for general-purpose deployment, and serve as conceptual guides for further research or adaptation.

## 🙏 Acknowledgements

We reference and build upon open-source releases from prior work on tensor low-rank models and transform-based optimization. See subfolders for detailed credits.
