import matplotlib.pyplot as plt

# 数据
x = list(range(0, 45, 2))
marginal_benefit = [0, -0.06944444444443594, 0.06349206349205636, 0.4375000000001013, 0.3160919540229677, 0.7991604778818204, 0.20346320346319072, 0.027734976887512624, 0.130841121495354, 0.17333333333333328, 1.1009174311926424, 0.5252525252525581, 0.7407407407407915, 0.7357560825377268, 0.27074235807860014, 0.7865058670143419, 0.7105263157894942, 0.4263322884012703, 0.41322314049588144, 0.14814814814817642, 0.7559256886611148, -0.706766917293288, 0.016528925619827887]
ssim = [0.69384, 0.69336, 0.69246, 0.6925399999999999, 0.6938, 0.65412, 0.65746, 0.65328, 0.65294, 0.65564, 0.61466, 0.61448, 0.6085, 0.6107199999999999, 0.6094, 0.56438, 0.5614399999999999, 0.56376, 0.56158, 0.56306, 0.51698, 0.5111399999999999, 0.51058]
ssim_base = 0.693
acceleration_ratio = [0.28822000000000003, 0.28812000000000004, 0.28832, 0.28803999999999996, 0.28694000000000003, 0.33643999999999996, 0.3355, 0.33568, 0.33582, 0.33504, 0.38282, 0.38334, 0.38273999999999997, 0.38394, 0.38332, 0.43158, 0.42996, 0.43132000000000004, 0.43082000000000004, 0.43054, 0.47774, 0.47868000000000005, 0.47864000000000007]
acceleration_ratio_base = 0.288
lpips_values_adjusted = [0.0523, 0.0547, 0.0601, 0.0589, 0.0532, 0.1374, 0.1315, 0.1403, 0.1421, 0.1358, 0.2247, 0.2265, 0.2189, 0.2233, 0.2174, 0.2951, 0.2876, 0.2963, 0.2917, 0.2894, 0.3682, 0.3597, 0.3543]
lpips_base = 0.053

# 左边子图：边际效益
plt.figure(figsize=(10, 6))  # 创建新的图形
plt.plot(x, marginal_benefit, 'o-', color='#E41A1C', label='Marginal Benefit')
plt.xlabel('Threshold (°)', fontsize=14)
plt.ylabel('Marginal Benefit', fontsize=14)
plt.tick_params(axis='both', which='major', labelsize=12)
plt.legend(loc='upper left', bbox_to_anchor=(0.05, 0.95), fontsize=12)
plt.grid(True, linestyle='--', alpha=0.5)
plt.title('Marginal Benefit vs Threshold', fontsize=14)
plt.tight_layout()
plt.savefig('marginal_benefit_plot.png')  # 保存为文件
plt.close()  # 关闭当前图形

# 右边子图：SSIM、加速比、LPIPS
plt.figure(figsize=(10, 6))  # 创建新的图形
plt.plot(x, ssim, 's-', color='#984EA3', label='SSIM')
plt.plot(x, acceleration_ratio, 'd-', color='#377EB8', label='Acceleration Ratio')
plt.plot(x, lpips_values_adjusted, '^-', color='tab:brown', label='LPIPS')

# 添加基准值的虚线
plt.axhline(y=ssim_base, color='#984EA3', linestyle='--', label='SSIM Baseline')
plt.axhline(y=acceleration_ratio_base, color='#377EB8', linestyle='--', label='Acceleration Ratio Baseline')
plt.axhline(y=lpips_base, color='tab:brown', linestyle='--', label='LPIPS Baseline')

plt.xlabel('Threshold (°)', fontsize=14)
plt.ylabel('Image Quality & Acceleration Ratio Metrics', fontsize=14)
plt.tick_params(axis='both', which='major', labelsize=12)
plt.legend(loc='upper left', bbox_to_anchor=(0.05, 0.90), fontsize=12)
plt.grid(True, linestyle='--', alpha=0.5)
plt.title('Image Quality and Acceleration Ratio Metrics vs Threshold', fontsize=14)
plt.tight_layout()
plt.savefig('image_quality_and_acceleration_plot.png')  # 保存为文件
plt.close()  # 关闭当前图形