import pyrender
import trimesh
import sys
import numpy as np

sys.setrecursionlimit(10000)

# 加载 .gltf 文件
model = trimesh.load_mesh("C:\\Users\\王政扬\\Downloads\\retro_computer\\scene.gltf")

# 如果加载的是一个 Scene 对象，则提取其中的 Mesh（这里取第一个）
if isinstance(model, trimesh.Scene):
    meshes = list(model.geometry.values())
    if len(meshes) == 0:
        raise ValueError("Scene 中没有有效的 mesh 对象")
    mesh = meshes[0]
else:
    mesh = model

# 居中模型：计算包围盒中心并平移使其居中
center = mesh.bounding_box.centroid
mesh.apply_translation(-center)

# 可选：根据模型尺寸进行缩放（这里以1.0为目标尺寸）
scale = 1.0 / max(mesh.extents)
mesh.apply_scale(scale)

# 将 trimesh 的 mesh 转换为 pyrender 的 Mesh 对象
pyr_mesh = pyrender.Mesh.from_trimesh(mesh, smooth=False)

# 创建 pyrender 的 Scene 并添加网格
scene = pyrender.Scene()
scene.add(pyr_mesh)


# 定义 look_at 函数
def look_at(eye, target, up):
    """
    根据 eye（摄像头位置）、target（目标点）和 up（上方向）生成摄像头变换矩阵
    """
    forward = target - eye
    forward = forward / np.linalg.norm(forward)
    right = np.cross(forward, up)
    right = right / np.linalg.norm(right)
    new_up = np.cross(right, forward)

    # 构造变换矩阵
    mat = np.eye(4)
    mat[0, :3] = right
    mat[1, :3] = new_up
    mat[2, :3] = -forward
    mat[:3, 3] = eye
    return mat


# 设定摄像头参数
distance = 2.5  # 摄像头到模型的距离
angle_offset = np.radians(90)  # 向右偏移 15°（顺时针旋转）

# 计算绕 Y 轴旋转 15° 后的新摄像机位置
x = distance * np.sin(angle_offset)  # 计算新的 x 位置
z = distance * np.cos(angle_offset)  # 计算新的 z 位置
eye = np.array([x, 0.0, z])  # 生成新的摄像机位置
target = np.array([0.0, 0.0, 0.0])  # 模型居中于原点
up = np.array([0.0, 1.0, 0.0])  # Y 轴正方向为上方向

# 计算相机变换矩阵
cam_pose = look_at(eye, target, up)

# 添加摄像头到场景
camera = pyrender.PerspectiveCamera(yfov=np.pi / 3.0)
scene.add(camera, pose=cam_pose)

# 启动渲染窗口（使用 Raymond 灯光）
pyrender.Viewer(scene, use_raymond_lighting=True)
