import pandas as pd

def normalize_yaw(yaw):
    """
    Normalize Yaw to [-180, 180].
    """
    return round(((yaw + 180) % 360) - 180, 1)

def fix_yaw_in_csv(input_file, output_file):
    """
    Load a CSV file, normalize the Yaw column, and save the corrected file.
    """
    # Load data
    df = pd.read_csv(input_file)

    # Normalize Yaw column
    df['Yaw'] = df['Yaw'].apply(normalize_yaw)

    # Save the fixed data
    df.to_csv(output_file, index=False)
    print(f"Fixed Yaw values saved to {output_file}")

# Example usage
fix_yaw_in_csv("views_with_roll.csv", "object_to_forget_angle/fixed_views_with_roll.csv")
