library(lme4)
library(caret)

cwd = getwd()
dir_name = paste(cwd, '/simulation-5/', sep='')
data_type_list = c('1000-10-0-fixed',
                   '1000-10-0.5-gamma',
                   '1000-10-1-gamma',
                   '1000-10-0.5-normal',
                   '1000-10-1-normal')

n_simul = 100
for(i in 1:length(data_type_list)){
  data_type = data_type_list[i]
  n_sub = as.integer(strsplit(data_type_list[i], split='-')[[1]][1])
  n_num = as.integer(strsplit(data_type_list[i], split='-')[[1]][2])
  GLMw_rmspe = rep(NA, n_simul)
  GLMM_rmspe = rep(NA, n_simul)
  for(k in 1:n_simul){
    file_name = paste(dir_name,'simul-data-',data_type,'-',as.character(k-1),'.csv', sep='')
    data = read.csv(file_name)
    data$id = as.factor(data$sub)
    data_train = data[data$num<=6,]
    data_test = data[data$num>8,]
    # Poisson GLM
    GLMw_res = glm(y~x0+x1+x2+x3+x4, family = poisson, data = data_train)
    mu_test  = predict(GLMw_res, data_test, type='response')
    GLMw_rmspe[k] = sqrt(mean((data_test$y-mu_test)^2/mu_test))
    # Poisson GLMM
    GLMM_res = glmer(y~x0+x1+x2+x3+x4+(1|id), data = data_train, family = "poisson")
    mu_test  = predict(GLMM_res, data_test, type='response')
    GLMM_rmspe[k] = sqrt(mean((data_test$y-mu_test)^2/mu_test))
  }
  print('================')
  print(data_type)
  print('===== GLMw =====')
  print(round(mean(GLMw_rmspe[k]),3))
  print(round(sd(GLMw_rmspe[k]),3))
  print('===== GLMM =====')
  print(round(mean(GLMw_rmspe[k]),3))
  print(round(sd(GLMw_rmspe[k]),3))
}