# Poisson-Gamma Neural Network
## Subject-specific Deep Neural Networks for Count Data with High-cardinality Categorical Features

This repository contains the source code and data files associated with our paper submission for ICLR 2024.

* The `PGNN.py` file includes the source code for training the Poisson-gamma neural networks, which presents the main findings of our paper.

* The `NNNN.py` file contains the source code for training neural networks with mixed effects.

* The `adjustment.ipynb` file includes the code for comparing the random effect predictions among PF-NN, PG-NN without adjustment, and PG-NN with adjustment in Section 4.3.

* The `feature_selection.ipynb` file includes the code for feature selection method with multi-head attention, derived in Section 4.4.

* The `data_generator.ipynb` file provides the code for generating the simulation data used in our experiments in Section 5.

* The `main_simulation.ipynb` file contains the code for running the simulation experiments and obtaining the corresponding results in Section 5.

* The `GLMs.R` file contains the code for running P-GLM and PN-GLM.

* The `real_data_analyses.ipynb` file includes the code for performing analyses on real data.

* The `variance_consistency.ipynb` file includes the code for running the experiments in Appendix A.4.

Please refer to the relevant files for more detailed information on each component.