# ✅ フィードバックの提供

OpenHandsを使用する際、うまくいく場合もあれば、そうでない場合もあります。開発チームにフィードバックを提供し、おそらくより重要なことですが、コーディングエージェントのトレーニング例のオープンなコーパスを作成するために、OpenHandsを使用する際にフィードバックを提供することをお勧めします -- Share-OpenHands!

## 📝 フィードバックの提供方法

フィードバックの提供は簡単です! OpenHandsを使用している際、インタラクションの任意のポイントで親指を上または下に向けるボタンを押すことができます。メールアドレスの入力を求められます (例: フォローアップの質問をしたい場合に連絡できるように)。また、フィードバックを公開するか非公開にするかを選択できます。

<iframe width="560" height="315" src="https://www.youtube.com/embed/5rFx-StMVV0?si=svo7xzp6LhGK_GXr" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>

## 📜 データの使用とプライバシー

### データ共有設定

データを送信する際、公開または非公開で送信できます。

- **公開**データは、OpenHands自体と同様にMITライセンスの下で配布され、コミュニティがモデルのトレーニングとテストに使用できます。明らかに、公開できるフィードバックは、コミュニティ全体にとってより価値があるでしょう。機密情報を扱っていない場合は、このオプションを選択することをお勧めします!
- **非公開**データは、OpenHandsの改善を目的としてOpenHandsチームが利用できるようになります。ただし、一意のIDを持つリンクが作成され、他の人と公開で共有できます。

### データの収集と保存は誰が行うのか?

データは、OpenHandsのメンテナーによって設立されたOpenHandsのサポートと改善を目的とする企業である[All Hands AI](https://all-hands.dev)によって収集および保存されます。

### 公開データはどのようにリリースされるのか?

公開データは、1,000件の公開例、10,000件の公開例などの固定されたマイルストーンに達した時点でリリースされます。
その際、以下のリリースプロセスに従います:

1. 公開フィードバックを提供したすべての人に、データのリリースについて説明し、オプトアウトする機会を与えるメールが送信されます。
2. データリリースを担当する人は、データの品質管理を行い、低品質のフィードバックを削除し、
提出者のメールアドレスを削除し、機密情報を削除するよう試みます。
3. データは、GitHubやHugging Faceなどの一般的に使用されているサイトを通じて、MITライセンスの下で公開されます。

### データを削除したい場合はどうすればよいですか?

All Hands AIのサーバー上のデータについては、リクエストに応じて削除いたします:

**1つのデータ:** 1つのデータを削除したい場合、データ送信時にインターフェイスに表示されるリンクとパスワードを使用してデータを削除するメカニズムを近日中に追加する予定です。

**すべてのデータ:** すべてのデータを削除したい場合、またはデータ送信時に受け取ったIDとパスワードがない場合は、元のデータ送信時に登録したメールアドレスから`contact@all-hands.dev`までご連絡ください。
