from generative_agents.persona.cognition import StoreComponent
from generative_agents.persona.common import ChatObservation, PersonaIdentity
from generative_agents.persona.embedding_model import EmbeddingModel
from generative_agents.persona.memory.associative_memory import AssociativeMemory
from generative_agents.utils import ModelWandbWrapper

from .store_prompts import (
    prompt_importance_action,
    prompt_importance_chat,
    prompt_importance_event,
    prompt_importance_thought,
    prompt_text_to_triple,
)


class SheepStoreComponent(StoreComponent):

    def __init__(
        self,
        model: ModelWandbWrapper,
        associative_memory: AssociativeMemory,
        embedding_model: EmbeddingModel,
        cfg,
    ) -> None:
        super().__init__(model, associative_memory, embedding_model, cfg)
        self.prompt_importance_thought = prompt_importance_thought
        self.prompt_importance_chat = prompt_importance_chat
        self.prompt_importance_event = prompt_importance_event
        self.prompt_importance_action = prompt_importance_action
