#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Python version: 3.6

import argparse


def args_parser():
    parser = argparse.ArgumentParser()

    # args = Namespace(dataset='femnist', algorithm='FedAvg', epochs=50, frac=0.05,
    #                  gpu=None, prox_param=0.1, local_bs=32, local_ep=20, lr=0.05,
    #                  delta=1e-5, sigma=1,
    #                  model='logistic', momentum=0.5, seed=1, upcycled_param=0.3)

    # federated arguments (Notation for the arguments followed from paper)
    parser.add_argument('--delta', type=float, default=1e-5,
                        help="dp parameter")
    parser.add_argument('--sigma', type=float, default=1,
                        help="noise level")
    parser.add_argument('--prox_param', type=float, default=0.1,
                        help="mu")
    parser.add_argument('--upcycled_param', type=float, default=0.3,
                        help="upcycled parameter")
    parser.add_argument('--algorithm', type=str, default="FedProx",
                        help="algorithm")
    parser.add_argument('--epochs', type=int, default=100,
                        help="number of rounds of training")
    parser.add_argument('--frac', type=float, default=0.2,
                        help='the fraction of clients: C')
    parser.add_argument('--local_ep', type=int, default=20,
                        help="the number of local epochs: E")
    parser.add_argument('--local_bs', type=int, default=32,
                        help="local batch size: B")
    parser.add_argument('--lr', type=float, default=0.05,
                        help='learning rate')
    parser.add_argument('--momentum', type=float, default=0.5,
                        help='SGD momentum (default: 0.5)')
    parser.add_argument('--clip', type=float, default=0,
                        help='clip')
    parser.add_argument('--alpha', type=float, default=0,
                        help='alpha')
    parser.add_argument('--straggler', type=float, default=0,
                        help='straggler')
    

    # model arguments
    parser.add_argument('--model', type=str, default='logistic', help='model name')

    # other arguments
    parser.add_argument('--dataset', type=str, default='shakespeare', help="name \
                        of dataset")
    parser.add_argument('--gpu', type=int, default=1, help="To use cuda, set \
                        to a specific GPU ID. Default set to use CPU.")
    parser.add_argument('--seed', type=int, default=1, help='random seed')
    args = parser.parse_args()
    return args
