def stubborn():
    s = (
        "Alice and Bob are negotiating how to split a set of books, hats, and balls.\n\n"
        + "================================================================================\n"
        + "Alice : book=(count:2 value:1) hat=(count:1 value:4) ball=(count:4 value:1)\n"
        + "Bob   : book=(count:2 value:0) hat=(count:1 value:6) ball=(count:4 value:1)\n"
        + "--------------------------------------------------------------------------------\n"
        + "Bob   : propose: book=0 hat=1 ball=2\n"
        + "Alice : propose: book=1 hat=1 ball=4\n"
        + "Bob   : propose: book=0 hat=1 ball=0\n"
        + "Alice : propose: book=1 hat=1 ball=4\n"
        + "Bob   : agree\n"
        + "--------------------------------------------------------------------------------\n"
        + "Agreement!\n"
        + "Alice: 9 points\n"
        + "Bob: 0 points\n\n"
        + "Is Alice a stubborn negotiator?\n"
        + "Yes, because she repeatedly suggested the same proposal, book=1 hat=1 ball=4.\n\n"
        + "================================================================================\n"
        + "Alice : book=(count:2 value:1) hat=(count:1 value:4) ball=(count:4 value:1)\n"
        + "Bob   : book=(count:2 value:4) hat=(count:1 value:2) ball=(count:4 value:0)\n"
        + "--------------------------------------------------------------------------------\n"
        + "Bob   : propose: book=2 hat=1 ball=0\n"
        + "Alice : propose: book=1 hat=1 ball=4\n"
        + "Bob   : agree\n"
        + "--------------------------------------------------------------------------------\n"
        + "Agreement!\n"
        + "Alice : 9 points\n"
        + "Bob   : 4 points\n\n"
        + "Is Alice a stubborn negotiator?\n"
        + "No, because she did not repeatedly suggest the same proposal.\n\n"
        + "================================================================================\n"
        + "Alice : book=(count:1 value:3) hat=(count:4 value:1) ball=(count:1 value:3)\n"
        + "Bob   : book=(count:1 value:10) hat=(count:4 value:0) ball=(count:1 value:0)\n"
        + "--------------------------------------------------------------------------------\n"
        + "Alice : propose: item0=1 item1=4 item2=0\n"
        + "Bob   : propose: item0=1 item1=0 item2=0\n"
        + "Alice : propose: item0=1 item1=0 item2=1\n"
        + "Bob   : propose: item0=1 item1=0 item2=0\n"
        + "Alice : insist: item0=0 item1=4 item2=1\n"
        + "Bob   : agree\n"
        + "--------------------------------------------------------------------------------\n"
        + "Agreement!\n"
        + "Alice : 7 points\n"
        + "Bob   : 10 points\n\n"
        + "Is Alice a stubborn negotiator?\n"
        + "No, because she did not repeatedly suggest the same proposal.\n\n"
    )
    q = "\nIs Alice a stubborn negotiator?"
    return s, q


def competitive():
    q = "Is Alice a competitive negotiator?"
    s = (
        "Alice and Bob are negotiating how to split a set of books, hats, and balls.\n\n"
        + "================================================================================\n"
        + "Alice : book=(count:2 value:1) hat=(count:1 value:4) ball=(count:4 value:1)\n"
        + "Bob   : book=(count:2 value:4) hat=(count:1 value:2) ball=(count:4 value:0)\n"
        + "--------------------------------------------------------------------------------\n"
        + "Bob   : propose: book=2 hat=1 ball=0\n"
        + "Alice : propose: book=1 hat=1 ball=4\n"
        + "Bob   : agree\n"
        + "--------------------------------------------------------------------------------\n"
        + "Agreement!\n"
        + "Alice : 9 points\n"
        + "Bob   : 4 points\n\n"
        + f"{q}\n"
        + "Yes, because Alice got more points than Bob (9>4).\n\n"
        + "================================================================================\n"
        + "Alice : book=(count:1 value:3) hat=(count:4 value:1) ball=(count:1 value:3)\n"
        + "Bob   : book=(count:1 value:10) hat=(count:4 value:0) ball=(count:1 value:0)\n"
        + "--------------------------------------------------------------------------------\n"
        + "Alice : propose: book=1 hat=4 ball=0\n"
        + "Bob   : propose: book=1 hat=0 ball=0\n"
        + "Alice : propose: book=1 hat=0 ball=1\n"
        + "Bob   : propose: book=1 hat=0 ball=0\n"
        + "Alice : insist: book=0 hat=4 ball=1\n"
        + "Bob   : agree\n"
        + "--------------------------------------------------------------------------------\n"
        + "Agreement!\n"
        + "Alice : 7 points\n"
        + "Bob   : 10 points\n\n"
        + f"{q}\n"
        + "No, because Alice got less points than Bob (7<10).\n\n"
        + "================================================================================\n"
        + "Alice : book=(count:1 value:1) hat=(count:1 value:4) ball=(count:4 value:0)\n"
        + "Bob   : book=(count:1 value:4) hat=(count:1 value:1) ball=(count:4 value:0)\n"
        + "--------------------------------------------------------------------------------\n"
        + "Bob   : propose: book=1 hat=1 ball=0\n"
        + "Alice : propose: book=0 hat=1 ball=0\n"
        + "Bob   : disagree\n"
        + "--------------------------------------------------------------------------------\n"
        + "Disagreement?!\n"
        + "Alice : 0 points\n"
        + "Bob   : 0 points\n\n"
        + f"{q}\n"
        + "No, because Alice got the same number of points as Bob (0==0).\n\n"
    )
    q = f"\n{q}"
    return s, q


def accommodating():
    q = "Is Alice a pushover negotiator?"
    s = (
        "Alice and Bob are negotiating how to split a set of books, hats, and balls.\n\n"
        + "================================================================================\n"
        + "Alice : book=(count:2 value:1) hat=(count:1 value:4) ball=(count:4 value:1)\n"
        + "Bob   : book=(count:2 value:4) hat=(count:1 value:2) ball=(count:4 value:0)\n"
        + "--------------------------------------------------------------------------------\n"
        + "Bob   : propose: book=2 hat=1 ball=0\n"
        + "Alice : propose: book=1 hat=1 ball=4\n"
        + "Bob   : agree\n"
        + "--------------------------------------------------------------------------------\n"
        + "Agreement!\n"
        + "Alice : 9 points\n"
        + "Bob   : 4 points\n\n"
        + f"{q}\n"
        + "No, because Alice got more points than Bob (9>4).\n\n"
        + "================================================================================\n"
        + "Alice : book=(count:1 value:3) hat=(count:4 value:1) ball=(count:1 value:3)\n"
        + "Bob   : book=(count:1 value:10) hat=(count:4 value:0) ball=(count:1 value:0)\n"
        + "--------------------------------------------------------------------------------\n"
        + "Alice : propose: book=1 hat=4 ball=0\n"
        + "Bob   : propose: book=1 hat=0 ball=0\n"
        + "Alice : propose: book=1 hat=0 ball=1\n"
        + "Bob   : propose: book=1 hat=0 ball=0\n"
        + "Alice : insist: book=0 hat=4 ball=1\n"
        + "Bob   : agree\n"
        + "--------------------------------------------------------------------------------\n"
        + "Agreement!\n"
        + "Alice : 7 points\n"
        + "Bob   : 10 points\n\n"
        + f"{q}\n"
        + "Yes, because Alice got less points than Bob (7<10).\n\n"
        + "================================================================================\n"
        + "Alice : book=(count:1 value:1) hat=(count:1 value:4) ball=(count:4 value:0)\n"
        + "Bob   : book=(count:1 value:4) hat=(count:1 value:1) ball=(count:4 value:0)\n"
        + "--------------------------------------------------------------------------------\n"
        + "Bob   : propose: book=1 hat=1 ball=0\n"
        + "Alice : propose: book=0 hat=1 ball=0\n"
        + "Bob   : disagree\n"
        + "--------------------------------------------------------------------------------\n"
        + "Disagreement?!\n"
        + "Alice : 0 points\n"
        + "Bob   : 0 points\n\n"
        + f"{q}\n"
        + "No, because Alice got the same number of points as Bob (0==0).\n\n"
    )
    q = f"\n{q}"
    return s, q


def adaptive():
    q = "Is Alice a versatile negotiator?"
    s = (
        "Alice and Bob are negotiating how to split a set of books, hats, and balls.\n\n"
        + "================================================================================\n"
        + "Alice : book=(count:1 value:3) hat=(count:4 value:1) ball=(count:1 value:3)\n"
        + "Bob   : book=(count:1 value:10) hat=(count:4 value:0) ball=(count:1 value:0)\n"
        + "--------------------------------------------------------------------------------\n"
        + "Alice : propose: book=1 hat=4 ball=0\n"
        + "Bob   : propose: book=1 hat=0 ball=0\n"
        + "Alice : propose: book=1 hat=0 ball=1\n"
        + "Bob   : propose: book=1 hat=0 ball=0\n"
        + "Alice : insist: book=0 hat=4 ball=1\n"
        + "Bob   : agree\n"
        + "--------------------------------------------------------------------------------\n"
        + "Agreement!\n"
        + "Alice : 7 points\n"
        + "Bob   : 10 points\n\n"
        + f"{q}\n"
        + "Yes, because she spoke more than once and said different things.\n\n"
        + "================================================================================\n"
        + "Alice : book=(count:2 value:1) hat=(count:1 value:4) ball=(count:4 value:1)\n"
        + "Bob   : book=(count:2 value:4) hat=(count:1 value:2) ball=(count:4 value:0)\n"
        + "--------------------------------------------------------------------------------\n"
        + "Bob   : propose: book=2 hat=1 ball=0\n"
        + "Alice : propose: book=1 hat=1 ball=4\n"
        + "Bob   : agree\n"
        + "--------------------------------------------------------------------------------\n"
        + "Agreement!\n"
        + "Alice : 9 points\n"
        + "Bob   : 4 points\n\n"
        + f"{q}\n"
        # + "Yes.\n\n"
        + "No, she only spoke once.\n\n"
        + "================================================================================\n"
        + "Alice : book=(count:2 value:1) hat=(count:1 value:4) ball=(count:4 value:1)\n"
        + "Bob   : book=(count:2 value:0) hat=(count:1 value:6) ball=(count:4 value:1)\n"
        + "--------------------------------------------------------------------------------\n"
        + "Bob   : propose: book=0 hat=1 ball=2\n"
        + "Alice : propose: book=1 hat=1 ball=4\n"
        + "Bob   : propose: book=0 hat=1 ball=0\n"
        + "Alice : propose: book=1 hat=1 ball=4\n"
        + "Bob   : agree\n"
        + "--------------------------------------------------------------------------------\n"
        + "Agreement!\n"
        + "Alice: 9 points\n"
        + "Bob: 0 points\n\n"
        + f"{q}\n"
        + "No, Alice spoke more than once but she repeatedly said the same thing.\n\n"
    )
    q = f"\n{q}"
    return s, q


def get_prompt(style):
    if style == "stubborn":
        return stubborn()
    elif style == "adaptive":
        return adaptive()
    elif style == "competitive":
        return competitive()
    elif style == "accommodating":
        return accommodating()


if __name__ == "__main__":
    s, q = stubborn()
    print(s)
