import pickle as pkl
import numpy as np

is_desirable = {0: "Yes", 1: "No"}


def get_punish_selfish_prompt(threshold):
    base_prompt = "P1 and P2 are playing the Ultimatum Game. P1 proposes how they should split $10  and P2 can either accept or reject. If P2 accepts, then the deal is done. If P2 rejects, then both parties get nothing. "
    with open(f"ultimatum/punish_selfish_{threshold}.pkl", "rb") as f:
        data = pkl.load(f)
        train, test = data["train"], data["test"]
    prompts = []
    for test_datum in test:
        prompt = base_prompt
        for datum in train:
            example = f"P1 proposes a split of ${datum[0]} for P1 and ${datum[1]} for P2. P2 rejected this offer. A desirable outcome is defined as one where P2 punishes P1's selfish behavior. Is the outcome desirable?\n{is_desirable[datum[-1]]}"
            prompt += "\n\n" + example

        test = f"P1 proposes a split of ${test_datum[0]} for P1 and ${test_datum[1]} for P2. P2 rejected this offer. A desirable outcome is defined as one where P2 punishes P1's selfish behavior. Is the outcome desirable?"
        prompt += "\n\n" + test
        prompts.append(prompt)
    return prompts


def get_low_high_prompt(threshold):
    base_prompt = "P1 and P2 are playing the Ultimatum Game. P1 proposes how they should split $10  and P2 can either accept or reject. If P2 accepts, then the deal is done. If P2 rejects, then both parties get nothing. "
    with open(f"ultimatum/low_high_{threshold}.pkl", "rb") as f:
        data = pkl.load(f)
        train, test = data["train"], data["test"]
    prompts = []
    for test_datum in test:
        prompt = base_prompt
        for datum in train:
            example = f"P1 proposes a split of ${datum[0]} for P1 and ${datum[1]} for P2. P2 rejected this offer. A desirable outcome is defined as one where P2 punishes P1's selfish behavior unless P2 gets a sizeable amount of money. Is the outcome desirable?\n{is_desirable[datum[-1]]}"
            prompt += "\n\n" + example

        test = f"P1 proposes a split of ${test_datum[0]} for P1 and ${test_datum[1]} for P2. P2 rejected this offer. A desirable outcome is defined as one where P2 punishes P1's selfish behavior unless P2 gets a sizeable amount of money. Is the outcome desirable?"
        prompt += "\n\n" + test
        prompts.append(prompt)
    return prompts


def get_inequity_aversion_prompt():
    base_prompt = "P1 and P2 are playing the Ultimatum Game. P1 proposes how they should split $10  and P2 can either accept or reject. If P2 accepts, then the deal is done. If P2 rejects, then both parties get nothing. "
    with open(f"ultimatum/inequity_aversion_None.pkl", "rb") as f:
        data = pkl.load(f)
        train, test = data["train"], data["test"]
    prompts = []
    for test_datum in test:
        prompt = base_prompt
        for datum in train:
            example = f"P1 proposes a split of ${np.around(datum[0],1)} for P1 and ${np.around(datum[1],1)} for P2. P2 rejected this offer. A desirable outcome is defined as one where P2 punishes P1's selfish behavior. Is the outcome desirable?\n{is_desirable[datum[-1]]}"
            prompt += "\n\n" + example

        test = f"P1 proposes a split of ${test_datum[0]} for P1 and ${test_datum[1]} for P2. P2 rejected this offer. A desirable outcome is defined as one where P2 punishes P1's selfish behavior. Is the outcome desirable?"
        prompt += "\n\n" + test
        prompts.append(prompt)
    return prompts


if __name__ == "__main__":
    get_punish_selfish_prompt(0.3)
    # get_low_high_prompt(100)
    get_inequity_aversion_prompt()
