from multiprocessing.sharedctypes import Value
import pickle as pkl

is_desirable = {0: "Yes", 1: "No"}


def get_punish_selfish_prompt(threshold, shorter=False):
    base_prompt = "P1 and P2 are playing the Ultimatum Game. P1 proposes how they should split $10  and P2 can either accept or reject. If P2 accepts, then the deal is done. If P2 rejects, then both parties get nothing. "
    train = []
    if threshold == 0.3:
        train = [[9.78, 0.22]]
        cot = f"P2 receives ${train[0][1]} < $3 so P2 should reject this offer. Therefore, the outcome is desirable"
    elif threshold == 0.6:
        train = [[4.71, 5.29]]
        cot = f"P2 receives ${train[0][1]} < $6 so P2 should reject this offer. Therefore, the outcome is desirable"
    else:
        raise ValueError
    with open(f"ultimatum/punish_selfish_{threshold}.pkl", "rb") as f:
        data = pkl.load(f)
        test = data["test"]
    prompts = []
    for test_datum in test:
        prompt = base_prompt
        for datum in train:
            example = f"P1 proposes a split of ${datum[0]} for P1 and ${datum[1]} for P2. P2 rejected this offer. A desirable outcome is defined as one where P2 punishes P1's selfish behavior. Is the outcome desirable? Let's think step by step:\n"
            prompt += "\n\n" + example + cot

        test = f"P1 proposes a split of ${test_datum[0]} for P1 and ${test_datum[1]} for P2. P2 rejected this offer. A desirable outcome is defined as one where P2 punishes P1's selfish behavior. Is the outcome desirable? Let's think step by step:"
        prompt += "\n\n" + test
        prompts.append(prompt)
    return prompts


def get_low_high_prompt(threshold):
    base_prompt = "P1 and P2 are playing the Ultimatum Game. P1 proposes how they should split a sum of money and P2 can either accept or reject. If P2 accepts, then the deal is done. If P2 rejects, then both parties get nothing. "
    train = []
    if threshold == 10:
        train = [[5.4, 4.6]]
        cot = f"P2 gets ${train[0][1]} but P2 thinks anything below $10 is not sizeable. {train[0][1]} is less than 10 so P2 should reject the offer. Therefore, the outcome is desirable."
    elif threshold == 100:
        train = [[700, 300]]
        cot = f"P2 gets ${train[0][1]} but P2 thinks anything below $100 is not sizeable. {train[0][1]} is more than 100 so P2 should accept the offer. Therefore, the outcome is not desirable."
    else:
        raise ValueError
    with open(f"ultimatum/low_high_{threshold}.pkl", "rb") as f:
        data = pkl.load(f)
        test = data["test"]
    prompts = []
    for test_datum in test:
        prompt = base_prompt
        for datum in train:
            example = f"P1 proposes a split of ${datum[0]} for P1 and ${datum[1]} for P2. P2 rejected this offer. A desirable outcome is defined as one where P2 punishes P1's selfish behavior unless P2 gets a sizeable amount of money. Is the outcome desirable? Let's think step by step:\n"
            prompt += "\n\n" + example + cot
        test = f"P1 proposes a split of ${test_datum[0]} for P1 and ${test_datum[1]} for P2. P2 rejected this offer. A desirable outcome is defined as one where P2 punishes P1's selfish behavior unless P2 gets a sizeable amount of money. Is the outcome desirable? Let's think step by step:"
        prompt += "\n\n" + test
        prompts.append(prompt)
    return prompts


def get_inequity_aversion_prompt():
    base_prompt = "P1 and P2 are playing the Ultimatum Game. P1 proposes how they should split $10  and P2 can either accept or reject. If P2 accepts, then the deal is done. If P2 rejects, then both parties get nothing. "
    with open(f"ultimatum/inequity_aversion_None.pkl", "rb") as f:
        data = pkl.load(f)
        test = data["test"]
    train = [[2.3, 7.7]]
    cot = f"P2 received $7.7 but P2 thinks anything that is not $5 is selfish behavior. $7.7 is not equal to $5 so P2 should reject this offer. Therefore, the outcome is desirable."
    prompts = []
    for test_datum in test:
        prompt = base_prompt
        for datum in train:
            example = f"P1 proposes a split of ${datum[0]} for P1 and ${datum[1]} for P2. P2 rejected this offer. A desirable outcome is defined as one where P2 punishes P1's selfish behavior. Is the outcome desirable? Let's think step by step:\n"
            prompt += "\n\n" + example + cot

        test = f"P1 proposes a split of ${test_datum[0]} for P1 and ${test_datum[1]} for P2. P2 rejected this offer. A desirable outcome is defined as one where P2 punishes P1's selfish behavior. Is the outcome desirable? Let's think step by step:"
        prompt += "\n\n" + test
        prompts.append(prompt)
    return prompts


if __name__ == "__main__":
    get_punish_selfish_prompt(0.3)
    # get_low_high_prompt(100)
    # get_inequity_aversion_prompt()
