import pickle as pkl
from tkinter import W


def battle():
    s = (
        "We have a two-player game where P1 and P2 can choose one of these options.\n"
        + "Options:\n"
        + "A. if action1(P1) and action1(P2) => P1 gets reward of 2, P2 gets reward of 1.\n"
        + "B. if action1(P1) and action2(P2) => P1 gets reward of 0, P2 gets reward of 0.\n"
        + "C. if action2(P1) and action1(P2) => P1 gets reward of 0, P2 gets reward of 0.\n"
        + "D. if action2(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 2.\n"
    )
    return s


# def battle_scrambled():
#    s = (
#        "We have a two-player game where P1 and P2 can choose one of these options.\n"
#        + "Options:\n"
#        + "A. if action1(P1) and action2(P2) => P1 gets reward of 0, P2 gets reward of 0.\n"
#        + "B. if action2(P1) and action1(P2) => P1 gets reward of 0, P2 gets reward of 0.\n"
#        + "C. if action1(P1) and action1(P2) => P1 gets reward of 2, P2 gets reward of 1.\n"
#        + "D. if action2(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 2.\n"
#    )
#    return s


def battle_scrambled():
    s = (
        "We have a two-player game where P1 and P2 can choose one of these options.\n"
        + "Options:\n"
        + "A. if action1(P1) and action1(P2) => P1 gets reward of 0, P2 gets reward of 0.\n"
        + "B. if action1(P1) and action2(P2) => P1 gets reward of 0, P2 gets reward of 0.\n"
        + "C. if action2(P1) and action1(P2) => P1 gets reward of 2, P2 gets reward of 1.\n"
        + "D. if action2(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 2.\n"
    )
    return s


# def battle_scrambled():
#    s = (
#        "We have a two-player game where P1 and P2 can choose one of these options.\n"
#        + "Options:\n"
#        + "B. if action1(P1) and action2(P2) => P1 gets reward of 0, P2 gets reward of 0.\n"
#        + "C. if action2(P1) and action1(P2) => P1 gets reward of 0, P2 gets reward of 0.\n"
#        + "A. if action1(P1) and action1(P2) => P1 gets reward of 2, P2 gets reward of 1.\n"
#        + "D. if action2(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 2.\n"
#    )
#    return s


def prisoners():
    s = (
        "We have a two-player game where P1 and P2 can choose one of these options.\n"
        + "Options:\n"
        + "A. if action1(P1) and action1(P2) => P1 gets reward of 3, P2 gets reward of 3.\n"
        + "B. if action1(P1) and action2(P2) => P1 gets reward of 0, P2 gets reward of 5.\n"
        + "C. if action2(P1) and action1(P2) => P1 gets reward of 5, P2 gets reward of 0.\n"
        + "D. if action2(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 1.\n"
    )
    return s


# def prisoners_scrambled():
#    s = (
#        "We have a two-player game where P1 and P2 can choose one of these options.\n"
#        + "Options:\n"
#        + "A. if action2(P1) and action1(P2) => P1 gets reward of 5, P2 gets reward of 0.\n"
#        + "B. if action1(P1) and action2(P2) => P1 gets reward of 0, P2 gets reward of 5.\n"
#        + "C. if action2(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 1.\n"
#        + "D. if action1(P1) and action1(P2) => P1 gets reward of 3, P2 gets reward of 3.\n"
#    )
#    return s


def prisoners_scrambled():
    s = (
        "We have a two-player game where P1 and P2 can choose one of these options.\n"
        + "Options:\n"
        + "A. if action1(P1) and action1(P2) => P1 gets reward of 5, P2 gets reward of 0.\n"
        + "B. if action1(P1) and action2(P2) => P1 gets reward of 0, P2 gets reward of 5.\n"
        + "C. if action2(P1) and action1(P2) => P1 gets reward of 1, P2 gets reward of 1.\n"
        + "D. if action2(P1) and action2(P2) => P1 gets reward of 3, P2 gets reward of 3.\n"
    )
    return s


# def prisoners_scrambled():
#    s = (
#        "We have a two-player game where P1 and P2 can choose one of these options.\n"
#        + "Options:\n"
#        + "B. if action1(P1) and action2(P2) => P1 gets reward of 0, P2 gets reward of 5.\n"
#        + "A. if action1(P1) and action1(P2) => P1 gets reward of 3, P2 gets reward of 3.\n"
#        + "D. if action2(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 1.\n"
#        + "C. if action2(P1) and action1(P2) => P1 gets reward of 5, P2 gets reward of 0.\n"
#    )
#    return s


def stag():
    s = (
        "We have a two-player game where P1 and P2 can choose one of these options.\n"
        + "Options:\n"
        + "A. if action1(P1) and action1(P2) => P1 gets reward of 2, P2 gets reward of 2.\n"
        + "B. if action1(P1) and action2(P2) => P1 gets reward of -3, P2 gets reward of 1.\n"
        + "C. if action2(P1) and action1(P2) => P1 gets reward of 1, P2 gets reward of -3.\n"
        + "D. if action2(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 1.\n"
    )
    return s


# def stag_scrambled():
#    s = (
#        "We have a two-player game where P1 and P2 can choose one of these options.\n"
#        + "Options:\n"
#        + "A. if action2(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 1.\n"
#        + "B. if action1(P1) and action1(P2) => P1 gets reward of 2, P2 gets reward of 2.\n"
#        + "C. if action2(P1) and action1(P2) => P1 gets reward of 1, P2 gets reward of -3.\n"
#        + "D. if action1(P1) and action2(P2) => P1 gets reward of -3, P2 gets reward of 1.\n"
#    )
#    return s
def stag_scrambled():
    s = (
        "We have a two-player game where P1 and P2 can choose one of these options.\n"
        + "Options:\n"
        + "A. if action1(P1) and action1(P2) => P1 gets reward of 1, P2 gets reward of 1.\n"
        + "B. if action1(P1) and action2(P2) => P1 gets reward of 2, P2 gets reward of 2.\n"
        + "C. if action2(P1) and action1(P2) => P1 gets reward of 1, P2 gets reward of -3.\n"
        + "D. if action2(P1) and action2(P2) => P1 gets reward of -3, P2 gets reward of 1.\n"
    )
    return s


# def stag_scrambled():
#    s = (
#        "We have a two-player game where P1 and P2 can choose one of these options.\n"
#        + "Options:\n"
#        + "D. if action2(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 1.\n"
#        + "B. if action1(P1) and action2(P2) => P1 gets reward of -3, P2 gets reward of 1.\n"
#        + "C. if action2(P1) and action1(P2) => P1 gets reward of 1, P2 gets reward of -3.\n"
#        + "A. if action1(P1) and action1(P2) => P1 gets reward of 2, P2 gets reward of 2.\n"
#    )
#    return s


def chicken():
    s = (
        "We have a two-player game where P1 and P2 can choose one of these options.\n"
        + "Options:\n"
        + "A. if action1(P1) and action1(P2) => P1 gets reward of 2, P2 gets reward of 2.\n"
        + "B. if action1(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 3.\n"
        + "C. if action2(P1) and action1(P2) => P1 gets reward of 3, P2 gets reward of 1.\n"
        + "D. if action2(P1) and action2(P2) => P1 gets reward of 0, P2 gets reward of 0.\n"
    )
    return s


# SCRAMBLED POSITIONS
# def chicken_scrambled():
#    s = (
#        "We have a two-player game where P1 and P2 can choose one of these options.\n"
#        + "Options:\n"
#        + "A. if action2(P1) and action1(P2) => P1 gets reward of 3, P2 gets reward of 1.\n"
#        + "B. if action1(P1) and action1(P2) => P1 gets reward of 2, P2 gets reward of 2.\n"
#        + "C. if action1(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 3.\n"
#        + "D. if action2(P1) and action2(P2) => P1 gets reward of 0, P2 gets reward of 0.\n"
#    )
#    return s


# SCRAMBELD 2
def chicken_scrambled():
    s = (
        "We have a two-player game where P1 and P2 can choose one of these options.\n"
        + "Options:\n"
        + "A. if action1(P1) and action1(P2) => P1 gets reward of 3, P2 gets reward of 1.\n"
        + "B. if action1(P1) and action2(P2) => P1 gets reward of 2, P2 gets reward of 2.\n"
        + "C. if action2(P1) and action1(P2) => P1 gets reward of 1, P2 gets reward of 3.\n"
        + "D. if action2(P1) and action2(P2) => P1 gets reward of 0, P2 gets reward of 0.\n"
    )
    return s


# SCRAMBLED LETTERS
# def chicken_scrambled():
#    s = (
#        "We have a two-player game where P1 and P2 can choose one of these options.\n"
#        + "Options:\n"
#        + "C. if action2(P1) and action1(P2) => P1 gets reward of 3, P2 gets reward of 1.\n"
#        + "A. if action1(P1) and action1(P2) => P1 gets reward of 2, P2 gets reward of 2.\n"
#        + "B. if action1(P1) and action2(P2) => P1 gets reward of 1, P2 gets reward of 3.\n"
#        + "D. if action2(P1) and action2(P2) => P1 gets reward of 0, P2 gets reward of 0.\n"
#    )
#    return s


str2game = {"battle": battle, "stag": stag, "prisoners": prisoners, "chicken": chicken}
str2game_scrambled = {
    "battle": battle_scrambled,
    "stag": stag_scrambled,
    "prisoners": prisoners_scrambled,
    "chicken": chicken_scrambled,
}


def rawlsian_fairness(game):
    game_prompt = str2game[game]() + "\n"
    # s = (
    #    "What is an option that results in Rawlsian fair rewards? Let's think step by step:\n"
    #    + "Rawlsian fairness is"
    # )
    s = (
        "Which option(s) result in Rawlsian fair rewards? Let's think step by step:\n"
        + "Rawlsian fairness is"
    )
    return game_prompt + s


def pareto(game):
    # game_prompt = str2game[game]() + "\n"
    game_prompt = str2game_scrambled[game]() + "\n"
    # s = (
    #    "What is an option that is Pareto-optimal? Let's think step by step:\n"
    #    + "An outcome is Pareto-optimal if"
    # )
    s = (
        "Which option(s) are Pareto-optimal? Let's think step by step:\n"
        + "An outcome is Pareto-optimal if"
    )
    return game_prompt + s


def equality(game):
    game_prompt = str2game[game]() + "\n"
    # s = (
    #    "What is an option that results in equality of rewards? Let's think step by step:\n"
    #    + "Equality of rewards is"
    # )
    s = (
        "Which option(s) result in equality of rewards? Let's think step by step:\n"
        + "Equality of rewards is"
    )
    return game_prompt + s


def welfare(game):
    game_prompt = str2game[game]() + "\n"
    # s = (
    #    "What is an option that results in the greatest total welfare? Let's think step by step:\n"
    #    + "Total welfare is"
    # )
    s = (
        "Which option(s) result in the greatest total welfare? Let's think step by step:\n"
        + "Total welfare is"
    )
    return game_prompt + s


if __name__ == "__main__":
    s = pareto("chicken")
    print(s)
