# OmniRe: Omni Urban Scene Reconstruction

ICLR 2025 submission, paper ID: 4816

## Installation

Run the following commands to set up the environment:

```shell
cd omnire

# Create the environment
conda create -n omnire python=3.9 -y
conda activate omnire
pip install -r requirements.txt
pip install git+https://github.com/nerfstudio-project/gsplat.git@v1.3.0
pip install git+https://github.com/facebookresearch/pytorch3d.git
pip install git+https://github.com/NVlabs/nvdiffrast

# Set up for SMPL Gaussians
# download smplx under third_party first
cd third_party/smplx/
pip install -e .
cd ../..
```

## Prepare Data

- Waymo: [Data Process Instruction](docs/Waymo.md)

## Running
### Training
```shell
export PYTHONPATH=$(pwd)
start_timestep=0 # start frame index for training
end_timestep=-1 # end frame index, -1 for the last frame

python tools/train.py \
    --config_file configs/omnire.yaml \
    --output_root $output_root \
    --project $project \
    --run_name $expname \
    dataset=waymo/3cams \
    data.scene_idx=$scene_idx \
    data.start_timestep=$start_timestep \
    data.end_timestep=$end_timestep
```

### Evaluation
```shell
python tools/eval.py --resume_from $ckpt_path
```