# Human Body Pose Processing Guide

## Prerequisites
:warning: To utilize the SMPL-Gaussians to model pedestrians, please first download the SMPL models.

1. Download SMPL v1.1 (`SMPL_python_v.1.1.0.zip`) from the [SMPL official website](https://smpl.is.tue.mpg.de/download.php)
2. Move `SMPL_python_v.1.1.0/smpl/models/basicmodel_neutral_lbs_10_207_0_v1.1.0.pkl` to `PROJECT_ROOT/smpl_models/SMPL_NEUTRAL.pkl`

## Obtaining Human Body Pose Data

**1. Update submodules and set up the environment:**
   ```bash
   # Create and activate the environment
   conda create --name 4D-humans python=3.10 -y
   conda activate 4D-humans

   # Install PyTorch
   pip install torch

   # Install 4D-Humans
   cd third_party/Humans4D
   pip install -e .[all]

   # Install additional dependencies
   pip install git+https://github.com/brjathu/PHALP.git
   pip install git+https://github.com/facebookresearch/pytorch3d.git

   # Return to the project root
   cd ../..
   ```

**2. Run the extraction script:**

   **Waymo**
   ```bash
   conda activate 4D-humans

   python datasets/tools/humanpose_process.py \
   --dataset waymo \
   --data_root data/waymo/processed/training \
   --split_file data/waymo_example_scenes.txt \
   [--save_temp] [--verbose]
   ```