import wx
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.backends.backend_wxagg import FigureCanvasWxAgg as FigureCanvas
from matplotlib.figure import Figure


class MainFrame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, None, title="交互界面", size=(800, 600))

        self.panel = wx.Panel(self)

        # 菜单栏
        self.menu_bar = wx.MenuBar()
        self.menus = []
        for i in range(9):
            menu = wx.Menu()
            menu_item = menu.Append(wx.ID_ANY, f"菜单{i+1}")
            self.Bind(wx.EVT_MENU, self.on_menu_select, menu_item)
            self.menus.append(menu)
            self.menu_bar.Append(menu, f"菜单{i+1}")
        self.SetMenuBar(self.menu_bar)

        # 图表和表格区域
        self.figure = Figure()
        self.canvas = FigureCanvas(self.panel, -1, self.figure)

        # 创建布局
        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.canvas, 1, wx.EXPAND)
        self.panel.SetSizer(sizer)

        # 数据
        self.table_data = np.random.randint(0, 100, size=(5, 3))

    def on_menu_select(self, event):
        selected_menu_index = event.GetId() - wx.ID_HIGHEST
        self.update_chart_and_table(selected_menu_index)

    def update_chart_and_table(self, menu_index):
        self.figure.clear()

        # 创建雷达图
        ax1 = self.figure.add_subplot(231, polar=True)
        categories = ['A', 'B', 'C', 'D', 'E']
        values = np.random.randint(0, 100, size=len(categories)).astype(float)
        angles = np.linspace(0, 2 * np.pi, len(categories), endpoint=False).tolist()
        values += angles[:1]
        ax1.plot(angles, values, 'o-', linewidth=2)
        ax1.fill(angles, values, alpha=0.25)
        ax1.set_xticks(angles)
        ax1.set_xticklabels(categories)

        # 创建折线图1
        ax2 = self.figure.add_subplot(232)
        x = np.linspace(0, 10, 100)
        y1 = np.sin(x)
        ax2.plot(x, y1, label='sin(x)')
        ax2.legend()

        # 创建折线图2
        ax3 = self.figure.add_subplot(233)
        x = np.linspace(0, 10, 100)
        y2 = np.cos(x)
        ax3.plot(x, y2, label='cos(x)')
        ax3.legend()

        # 创建表格
        ax4 = self.figure.add_subplot(212)
        ax4.axis('off')
        ax4.table(cellText=self.table_data.tolist(), loc='center')

        self.canvas.draw()


if __name__ == '__main__':
    app = wx.App()
    frame = MainFrame()
    frame.Show()
    app.MainLoop()
