import os
import numpy as np
from PIL import Image
from metrics.psnr_ssim import calculate_ssim, calculate_psnr

folder1 = 'target_path'
folder2 = 'predict_path'


files1 = set(os.listdir(folder1))
files2 = set(os.listdir(folder2))

common_files = files1.intersection(files2)

psnr_scores = []
ssim_scores = []
c = 0

for file_name in common_files:
    c += 1
    img1_path = os.path.join(folder1, file_name)
    img2_path = os.path.join(folder2, file_name)


    img1 = Image.open(img1_path).convert('RGB')
    img2 = Image.open(img2_path).convert('RGB')

    img1_np = np.array(img1)
    img2_np = np.array(img2)


    psnr_score =  calculate_psnr(img1_np, img2_np, crop_border=0, test_y_channel=False)
    ssim_score = calculate_ssim(img1_np, img2_np, crop_border=0, test_y_channel=False)

    psnr_scores.append(psnr_score)
    ssim_scores.append(ssim_score)
    print(c, '/' ,len(common_files), 'PSNR: ',psnr_score, 'SSIM:',ssim_score)

average_psnr = sum(psnr_scores) / len(psnr_scores)
average_ssim = sum(ssim_scores) / len(ssim_scores)


print(f"Average PSNR: {average_psnr:.2f}")
print(f"Average SSIM: {average_ssim:.4f}")