#!/bin/bash

# Parameter lists
perturbation_types=("soft")
method_types=("jci_gsp" "igsp" "ut_igsp")
node_nums=(10 15 20 25)
sample_nums=(500 1000 1500 2000)
seeds=($(seq 0 9))  # Seeds from 0 to 9

# Iterate over all combinations
for perturbation in "${perturbation_types[@]}"; do
  for method in "${method_types[@]}"; do
    for node in "${node_nums[@]}"; do
      for sample in "${sample_nums[@]}"; do
        for seed in "${seeds[@]}"; do
          # Construct and run the command
          command="python main.py --perturbation_type $perturbation --method_type $method --nodenum $node --samplenum $sample --seed $seed"
          echo "Running: $command"
          $command  # Run the command
        done
      done
    done
  done
done
