#!/bin/sh
#SBATCH --job-name=ours
#SBATCH --output=ours_output.txt
#SBATCH --error=ours_error.txt
#SBATCH -p cpu
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=2
#SBATCH --mem=8GB
#SBATCH --time=4-00:00:00

echo "job starting"
module load anaconda3
source activate /home/zing/.conda/envs/causal/


declare -a seeds=("1" "2" "3" "4" "5" "6" "7" "8" "9" "10")
declare -a samplenums=("3000" )
declare -a nodenums=("5" "10" "15" "20")

###################### Experiments ######################
for i in "${seeds[@]}"
do
    for j in "${nodenums[@]}"
    do
        for k in "${samplenums[@]}"
        do
            # Linear SEM
            python main.py --seed "$i" \
                            --samplenum "$k" \
                            --nodenum "$j" \
                            --degree 2 \
                            --data_type linear \
                            --noise_type gauss \
                            --max_selection_num 4 \
                            --max_single_selection_num 3 \
                            --num_of_interv_configs 10 \
                            --max_single_intervention_num 4 \
                            --method_type ours \
                            --CI_type fisherz \
                            --alpha 0.05
        done
    done
done
######################################################
echo "job finished"