import os
import cv2
import numpy as np



video_path = 'viz.avi'
fourcc = cv2.VideoWriter_fourcc('M', 'J', 'P', 'G')
out = cv2.VideoWriter(video_path, fourcc, 30, (180, 180))


data_folder = os.path.join('/home/yunzhu/data/nerf_dy/data_FluidShakeWithIce_wKuka/0')

time_step = 300
n_view = 40
viz_views_per_iter = 70


for i in range(time_step):

    if i % viz_views_per_iter == 0:
        for j in range(n_view):
            img = cv2.imread(os.path.join(data_folder, '%d/%d.jpg' % (j, i)))
            out.write(img)

        for j in range(n_view - 1, -1, -1):
            img = cv2.imread(os.path.join(data_folder, '%d/%d.jpg' % (j, i)))
            out.write(img)

    else:
        img = cv2.imread(os.path.join(data_folder, '0/%d.jpg' % (i)))
        out.write(img)

out.release()



