import os
import cv2
import time
import numpy as np





# ae_folder = os.path.join('dump/dump_FluidManipClip/eval_dy_nHis5_ct_nerf_dyEpoch_4_dyIter_24000')
ae_folder = os.path.join('dump/dump_FluidManipClip_wKuka_wColor/eval_dy_nHis5_nerf_dyEpoch_19_dyIter_16000')
# ae_folder = os.path.join('dump/dump_FluidShakeWithIce_1000/eval_dy_nHis5_ct_nerf_dyEpoch_12_dyIter_4000')
# ae_folder = os.path.join('dump/dump_FluidShakeWithIce_wKuka_wColor_wGripper/eval_dy_nHis5_nerf_dyEpoch_19_dyIter_28000')
# ae_folder = os.path.join('dump/dump_RigidFall/eval_dy_nHis5_ct_nerf_dybest')

st_idx = 80
time_step = 200
n_view = 20
offset = 20


video_path = os.path.join(ae_folder, 'viz_eval_%d_gt.avi' % (st_idx))
fourcc = cv2.VideoWriter_fourcc('M', 'J', 'P', 'G')
out = cv2.VideoWriter(video_path, fourcc, 30, (180, 180))

for i in range(time_step):
    idx = 5
    path = os.path.join(ae_folder, '%d/gt_%d_%d.png' % (st_idx, i, idx))
    img = cv2.imread(path)
    print(img.shape)
    out.write(img)

    if i % offset == 0:

        for j in range(idx + 1, n_view):
            img = cv2.imread(os.path.join(ae_folder, '%d/gt_%d_%d.png' % (st_idx, i, j)))
            out.write(img)

        for j in range(n_view - 1, -1, -1):
            img = cv2.imread(os.path.join(ae_folder, '%d/gt_%d_%d.png' % (st_idx, i, j)))
            out.write(img)

        for j in range(1, idx + 1):
            img = cv2.imread(os.path.join(ae_folder, '%d/gt_%d_%d.png' % (st_idx, i, j)))
            out.write(img)


out.release()


video_path = os.path.join(ae_folder, 'viz_eval_%d_pred.avi' % (st_idx))
fourcc = cv2.VideoWriter_fourcc('M', 'J', 'P', 'G')
out = cv2.VideoWriter(video_path, fourcc, 30, (180, 180))

for i in range(time_step):
    idx = 5
    path = os.path.join(ae_folder, '%d/pred_%d_%d.png' % (st_idx, i, idx))
    img = cv2.imread(path)
    print(img.shape)
    out.write(img)

    if i % offset == 0:

        for j in range(idx + 1, n_view):
            img = cv2.imread(os.path.join(ae_folder, '%d/pred_%d_%d.png' % (st_idx, i, j)))
            out.write(img)

        for j in range(n_view - 1, -1, -1):
            img = cv2.imread(os.path.join(ae_folder, '%d/pred_%d_%d.png' % (st_idx, i, j)))
            out.write(img)

        for j in range(1, idx + 1):
            img = cv2.imread(os.path.join(ae_folder, '%d/pred_%d_%d.png' % (st_idx, i, j)))
            out.write(img)


out.release()





'''
for k in range(n_view):
    video_path = os.path.join(ae_folder, 'viz_eval_%d_%d.avi' % (st_idx, k))
    fourcc = cv2.VideoWriter_fourcc('M', 'J', 'P', 'G')
    out = cv2.VideoWriter(video_path, fourcc, 30, (360, 180))


    for i in range(time_step):
        print(os.path.join(ae_folder, '%d/gt_%d_%d.png' % (st_idx, i, k)))
        # print(os.path.join(ae_folder, '%d/pred_%d_%d.png' % (st_idx, i, k)))
        print(os.path.join(ae_folder, '%d/pred_%d_%d.png' % (st_idx, i, k)))

        gt = cv2.imread(os.path.join(ae_folder, '%d/gt_%d_%d.png' % (st_idx, i, k)))
        # ae = cv2.imread(os.path.join(ae_folder, '%d/pred_%d_%d.png' % (st_idx, i, k)))
        dec = cv2.imread(os.path.join(ae_folder, '%d/pred_%d_%d.png' % (st_idx, i, k)))

        img = np.concatenate([gt, dec], 1)
        out.write(img)

    out.release()
'''



