import os
import cv2
import numpy as np



data_folder = os.path.join('dump/dump_FluidManipClip_wKuka_wColor/eval_nn_nHis1_ct_nerf_dyEpoch_2_dyIter_125000/0')
data_folder = os.path.join('dump/dump_FluidShakeWithIce_wKuka_wColor_wGripper/eval_nn_nHis1_ct_nerf_dyEpoch_2_dyIter_110000/0')

skip = 1
st_idx = 0
time_step = 300
n_view = 4

border = 3


video_path = data_folder + '.avi'
print("Storing video to %s ..." % video_path)

fourcc = cv2.VideoWriter_fourcc('M', 'J', 'P', 'G')
out = cv2.VideoWriter(video_path, fourcc, 20, (180 * (n_view + 1), 180))



for i in range(st_idx, st_idx + time_step, skip):

    imgs = []

    img = cv2.imread(os.path.join(data_folder, 'img_%d.png' % i))
    img[:, :border] = np.array([0, 0, 255])
    img[:, -border:] = np.array([0, 0, 255])
    img[:border, :] = np.array([0, 0, 255])
    img[-border:, :] = np.array([0, 0, 255])
    imgs.append(img)

    for j in range(n_view):
        img = cv2.imread(os.path.join(data_folder, 'img_%d_%d.png' % (i, j)))
        imgs.append(img)

    img = np.concatenate(imgs, 1)
    out.write(img)

out.release()



