import cv2
from torchvision import transforms
import imageio
import torch
import numpy as np

name = 'pour'  # shake or pour
traj_id = 5  # 20
view = 3 # 20
fram_num = 217
fps = 10
interval = 2
mode = 'water'
dset = 'pour_real'
w='w'
image_folder = "/home/htxue/datasets/data_real_FluidPourTagCorrect/{}/{}/".format(traj_id, view)

fram_list = range(0, fram_num, interval)

frame = None

def get_image_to_tensor_balanced(image_size=0):
    ops = []
    if image_size > 0:
        ops.append(transforms.Resize(image_size))
    ops.extend(
        [transforms.ToTensor()]
    )
    return transforms.Compose(ops)


image2tensor = get_image_to_tensor_balanced()

frame = []

for i in fram_list:
    print(i)
    image = imageio.imread(image_folder + str(i) + ".jpg")
    image[(image == 0).all(-1), :] = 255
    image = image2tensor(image)
    C, H, W = image.shape
    image = image.permute(1, 2, 0)
    frame.append(image.cpu().numpy())

frames = np.stack(frame)
print(frames.shape)
imageio.mimwrite(
    'videos/video{}_{}_{}_{}views.mp4'.format(dset, mode, traj_id, w), (frames * 255).astype(np.uint8), fps=fps, quality=8
)

