import torch
import os

def mat2pcl(N, voxel_mat, valid):
    """
    from voxel-mat to point cloud
    :param voxel_mat: N * N * N feature
    :param valid: N * N * N bool
    :return: N * N * N * [X, Y, Z, feature_dim]
    """

    voxel_mat = voxel_mat.view(N, N, N, -1)
    valid = valid.view(N, N, N)

    idx = valid.nonzero()  # (K * 3)

    pcl_feature = voxel_mat[valid]

    pcl_rep = torch.cat([idx, pcl_feature], dim=-1)

    return pcl_rep


mode = 'pour'
src_pth  = '/home/htxue/data/mit/pixel-nerf/datasets/dynamics/fluid_{}_whitebkg_4views/'.format(mode)
N = 100

for traj_id in range(20):
    print(traj_id)
    for frame_id in range(300):
        folder = src_pth + "{}/{}/".format(traj_id, frame_id)

        voxel_mat = torch.load(folder + "feature_voxel.bin")
        valid = torch.load(folder + "valid.bin")
        sigma_valid = torch.load(folder + "sigma_valid.bin")

        voxel_mat, valid, sigma_valid = torch.from_numpy(voxel_mat), torch.from_numpy(valid), torch.from_numpy(sigma_valid)

        pcl_water = mat2pcl(N + 1, voxel_mat, valid)
        pcl_all = mat2pcl(N + 1, voxel_mat, sigma_valid)

        torch.save(pcl_water, folder + "pcl_water.bin")
        torch.save(pcl_all, folder + "pcl_all.bin")

        print(frame_id)

        # os.system("rm -rf {}/feature_voxel.bin".format(folder))
        # os.system("rm -rf {}/sigma_valid.bin".format(folder))
        # os.system("rm -rf {}/valid.bin".format(folder))

