import open3d as o3d
import torch
import numpy as np
import argparse
parser = argparse.ArgumentParser()
parser.add_argument("--traj", type=int, help='traj id')
parser.add_argument("--frame", type=int, help='frame id')
args = parser.parse_args()
trj, fram = args.traj, args.frame


src_pth = "../datasets/dynamics/fluid_pour_whitebkg_wview/{}/{}/".format(trj, fram)


xyz_range = torch.load(src_pth + 'xyz_range.bin')
print(xyz_range)
x_min, y_min, z_min = xyz_range[0][0], xyz_range[1][0], xyz_range[2][0]
x_max, y_max, z_max = xyz_range[0][-1], xyz_range[1][-1], xyz_range[2][-1]
N = xyz_range[0].shape[0]

def rescale(pcl_mat, min, max, N):
    min, max = np.array(min), np.array(max)
    scale = (max - min) / N
    assert scale[0] == scale[1] == scale[2]
    pcl_mat = pcl_mat * scale + min
    return pcl_mat



a = torch.load(src_pth + "pcl_water.bin")
a = a[:, :3]
a = rescale(a, [x_min, y_min, z_min], [x_max, y_max, z_max], N)
        

print(a)
pcd=o3d.geometry.PointCloud()
pcd.points = o3d.utility.Vector3dVector(a)
o3d.visualization.draw_geometries([pcd], mesh_show_wireframe=True, point_show_normal=True)


