#!/bin/bash

# 检查参数数量
if [ $# -lt 4 ]; then
    echo "用法: $0 <model> <template> <tasks> <device> [suffix]"
    exit 1
fi

model=$1
template=$2
tasks=$3
device=$4
suffix=$5  # 第五个参数，可以为空

# 根据model确定adapter_folder
case $model in
    "Ochat8B")
        adapter_folder="Ochat_8B_adapters_new"
        ;;
    "llama3.2-3B")
        adapter_folder="llama32_adapters_new"
        ;;
    "Qwen2-7B")
        adapter_folder="qwen2_adapters_new"
        ;;
    *)
        echo "未知的model: $model"
        echo "支持的model: Ochat8B, llama3.2-3B, Qwen2-7B"
        exit 1
        ;;
esac

config_file="configs/${tasks}_${template}.json"


# 执行第一个命令生成配置文件
echo "生成配置文件: $config_file"
python launch.py gen --template "$template" --tasks "$tasks" --file_name "$config_file"

# 检查上一个命令是否成功执行
if [ $? -ne 0 ]; then
    echo "配置文件生成失败"
    exit 1
fi

# 构建文件名，如果有后缀则添加
if [ -n "$suffix" ]; then
    dir_folder="${adapter_folder}/${template}_${suffix}.json"
else
    dir_folder="${adapter_folder}/${template}.json"
fi

# 执行第二个命令进行训练
echo "开始训练..."
CUDA_VISIBLE_DEVICES="$device" python moe_peft.py \
    --base_model "/data/models/$model" \
    --config "$config_file" \
    --bf16 \
    --dir "$dir_folder"

# 检查训练命令是否成功执行
if [ $? -ne 0 ]; then
    echo "训练失败"
    exit 1
fi

echo "任务完成"