import matplotlib.pyplot as plt
import numpy as np

    
def load_res(res_id,last_cvar):
    alpha=0.0001
    n_quantiles=100
    max_iter=200000
    n_rep=1000
    all_res=[]
    for stock_i in range(10):
        res=[]
        for n_cvar in np.arange(50,last_cvar+5,5):
            r2=[]
            for seed in [1,2,3]:
                r=np.sort(np.load('res/{}_option_res{}_eval_{:g}_{}_{}_{}_{}_{}.npy'.format(res_id,stock_i,alpha,max_iter,n_quantiles,n_cvar,n_rep,seed)))
                r2.append( np.mean(r[1,:(n_cvar*n_rep//100)]) )
            res.append(np.mean(r2))
        all_res.append(res)
    return np.array(all_res)

def load_res_exp():
    alpha=0.0001
    n_quantiles=100
    max_iter=200000
    n_rep=1000
    all_res=[]
    for stock_id in range(10):
        res=[]
        for seed in [1,2,3]:
            r=np.sort(np.load('res/dqr_option_res{}_eval_{:g}_{}_{}_100_{}_{}.npy'.format(stock_id,alpha,max_iter,n_quantiles,n_rep,seed)))
            r2=[]
            for n_cvar in np.arange(50,105,5):
                r2.append( np.mean(r[1,:(n_cvar*n_rep//100)]) )
            res.append(r2)
        all_res.append( np.mean(res,axis=0) )
    return np.array(all_res)

plt.ion()

plt.figure(1)
plt.clf()
tau_rng=np.arange(0.5,1.0,0.05)
res=load_res('dqr4',95)
plt.errorbar(tau_rng,np.mean(res,axis=0),np.std(res,axis=0)*2/np.sqrt(10),fmt='.-',capsize=3)
tau_rng=np.arange(0.5,1.05,0.05)
res=load_res('dqr',100)
plt.errorbar(tau_rng,np.mean(res,axis=0),np.std(res,axis=0)*2/np.sqrt(10),fmt='.-',capsize=3)
res=load_res_exp()
plt.errorbar(tau_rng,np.mean(res,axis=0),np.std(res,axis=0)*2/np.sqrt(10),fmt='.-',capsize=3)
plt.grid()
plt.legend(['Static','Dynamic','Expectation'])
plt.xlabel('alpha level')
plt.ylabel('CVaR')

