#!/bin/bash

# merge pt model 
log_path="../log/"
# merge sft model(deepseek-32B)
PRETRAIN_MODEL_DIR="../resource/model/pt_model/DeepSeek-R1-Distill-Qwen-32B"
ADAPTER_MODEL_DIR="../resource/model/sft_model/"
OUTPUT_MODEL_DIR="../resource/model/sft_model/deepseek-32B-sft-merge-v1"

nohup python ../src/export.py \
    --model_name_or_path $PRETRAIN_MODEL_DIR \
    --adapter_name_or_path $ADAPTER_MODEL_DIR \
    --template deepseek3 \
    --finetuning_type lora \
    --export_dir $OUTPUT_MODEL_DIR \
    --export_size 4 \
    --export_device cpu \
    --export_legacy_format false > $log_path/deepseek-32B-sft-merge-v1.log 2>&1 &
