#!/bin/bash
log_path="../log/"
CONFIG_DIR="../config"
DATA_DIR="../resource/dataset"
PRETRAIN_MODEL_DIR="../resource/model/pt_model/DeepSeek-R1-Distill-Qwen-32B"
OUTPUT_SFTMODEL_DIR="../resource/model/sft_model/deepseek-32B-sft-lora-v1"

nohup deepspeed --include localhost:0,1 --master_port=9901 ../src/train.py \
    --deepspeed $CONFIG_DIR/ds_z3_config.json \
    --stage sft \
    --model_name_or_path $PRETRAIN_MODEL_DIR \
    --do_train \
    --dataset_dir $DATA_DIR \
    --dataset data_train \
    --template deepseek3 \
    --finetuning_type lora \
    --lora_rank 8 \
    --lora_target all \
    --overwrite_cache \
    --output_dir $OUTPUT_SFTMODEL_DIR \
    --per_device_train_batch_size 1 \
    --gradient_accumulation_steps 4 \
    --preprocessing_num_workers 4 \
    --optim paged_adamw_32bit \
    --lr_scheduler_type cosine \
    --logging_steps 10 \
    --save_steps 100 \
    --eval_steps 100 \
    --warmup_steps 200 \
    --learning_rate 2e-5 \
    --max_grad_norm 0.5 \
    --max_steps 800 \
    --num_train_epochs 5.0 \
    --plot_loss \
    --save_total_limit 4 \
    --overwrite_output_dir \
    --cutoff_len 2048 \
    --flash_attn auto \
    --bf16 > $log_path/deepseek-32B-sft-lora-v1.log 2>&1 &
