#!/usr/bin/env bash
set -e
ROOT="$(dirname "$0")"
XZ_FILE="${ROOT}/weights/adapter_model.safetensors.xz"
TARGET_DIR="${ROOT}/LLMTrainProject/resource/model/sft_adapter/"
TARGET_FILE="${TARGET_DIR}/adapter_model.safetensors"

if [ -f "${TARGET_FILE}" ]; then
  echo "✓ LoRA adapter already present."
  exit 0
fi

mkdir -p "${TARGET_DIR}"
echo "🔄 Decompressing LoRA adapter → ${TARGET_FILE}"
xz -dk --threads=0 "${XZ_FILE}" -c > "${TARGET_FILE}"
echo "✅ Done."
