import numpy as np


def draw_prior_m1a():
    """Draws samples from the prior distributions of m1a."""

    # drift    ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 2.0)
    # beta     ~ U(0.1, 0.9)
    # mu_tau_e ~ U(0.05, 0.6)
    # tau_m    ~ U(0.06, 0.8)
    # sigma    ~ U(0.0, 0.3)
    # varsigma ~ U(0.0, 0.3)

    prior_samples = np.random.uniform(
        low=(-3.0, 0.5, 0.1, 0.05, 0.06, 0.0, 0.0),
        high=(3.0, 2.0, 0.9, 0.6, 0.8, 0.3, 0.3)
    )
    return prior_samples


def draw_prior_m1b():
    """Draws samples from the prior distributions of m1b."""

    # drift    ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 2.0)
    # beta     ~ U(0.1, 0.9)
    # mu_tau_e ~ U(0.05, 0.6)
    # mu_tau_m ~ U(0.06, 0.8)
    # sigma    ~ U(0.0, 0.3)
    # varsigma ~ U(0.0, 0.3)

    prior_samples = np.random.uniform(
        low=(-3.0, 0.5, 0.1, 0.05, 0.06, 0.0, 0.0),
        high=(3.0, 2.0, 0.9, 0.6, 0.8, 0.3, 0.3)
    )
    return prior_samples


def draw_prior_m1c():
    """Draws samples from the prior distributions of m1c."""

    # drift    ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 2.0)
    # beta     ~ U(0.1, 0.9)
    # mu_tau_e ~ U(0.05, 0.4)
    # tau_m    ~ U(0.06, 0.6)
    # sigma    ~ U(0.0, 0.1)
    # varsigma ~ U(0.0, 0.1)

    prior_samples = np.random.uniform(
        low=(-3.0, 0.5, 0.1, 0.05, 0.06, 0.0, 0.0),
        high=(3.0, 2.0, 0.9, 0.4, 0.6, 0.1, 0.1)
    )
    return prior_samples


def draw_prior_m2():
    """Draws samples from the prior distributions of m2."""

    # drift    ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 2.0)
    # beta     ~ U(0.1, 0.9)
    # mu_tau_e ~ U(0.05, 0.6)
    # tau_m    ~ U(0.06, 0.8)
    # sigma    ~ U(0.0, 0.3)
    # varsigma ~ U(0.0, 0.3)
    # gamma    ~ U(0.0, 3.0)

    prior_samples = np.random.uniform(
        low=(-3.0, 0.5, 0.1, 0.05, 0.06, 0.0, 0.0, 0.0),
        high=(3.0, 2.0, 0.9, 0.6, 0.8, 0.3, 0.3, 3.0)
    )
    return prior_samples


def draw_prior_m3():
    """Draws samples from the prior distributions of m3."""

    # drift    ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 2.0)
    # beta     ~ U(0.1, 0.9)
    # mu_tau_e ~ U(0.05, 0.6)
    # tau_m    ~ U(0.06, 0.8)
    # sigma    ~ U(0.0, 0.3)
    # varsigma ~ U(0.0, 0.3)
    # theta    ~ U(0.0, 1.0)

    prior_samples = np.random.uniform(
        low=(-3.0, 0.5, 0.1, 0.05, 0.06, 0.0, 0.0, 0.0),
        high=(3.0, 2.0, 0.9, 0.6, 0.8, 0.3, 0.3, 1.0)
    )
    return prior_samples


def draw_prior_m4a():
    """Draws samples from the prior distributions of m4a."""

    # drift    ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 2.0)
    # beta     ~ U(0.1, 0.9)
    # mu_tau_e ~ U(0.05, 0.6)
    # tau_m    ~ U(0.06, 0.8)
    # tau      ~ U(0.1, 1.0)
    # sigma_e  ~ U(0.0, 0.3)
    # sigma_k  ~ U(0.0, 0.3)
    # varsigma ~ U(0.0, 0.3)
    # k        ~ U(0.05, 0.4)
    # theta    ~ U(0.0, 1.0)

    prior_samples = np.random.uniform(
        low=(-3.0, 0.5, 0.1, 0.05, 0.06, 0.1, 0.0, 0.0, 0.0, 0.05, 0.0),
        high=(3.0, 2.0, 0.9, 0.6, 0.8, 1.0, 0.3, 0.3, 0.3, 0.4, 1.0)
    )
    return prior_samples


def draw_prior_m4b():
    """Draws samples from the prior distributions of m4b."""

    # drift ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 2.0)
    # beta ~ U(0.1, 0.9)
    # mu_tau_e ~ U(0.05, 0.6)
    # tau_m ~ U(0.06, 0.8)
    # sigma_e ~ U(0.0, 0.3)
    # varsigma ~ U(0.0, 0.3)
    # theta ~ U(0, 1)

    prior_samples = np.random.uniform(
        low=(-3.0, 0.5, 0.1, 0.05, 0.06, 0.0, 0.0, 0.0),
        high=(3.0, 2.0, 0.9, 0.6,  0.8,  0.3, 0.3, 1.0)
    )
    return prior_samples


def draw_prior_m5():
    """Draws samples from the prior distributions of m5."""

    # drift    ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 2.0)
    # beta     ~ U(0.1, 0.9)
    # mu_tau_e ~ U(0.05, 0.6)
    # tau_m    ~ U(0.06, 0.8)
    # sigma    ~ U(0.0, 0.3)
    # varsigma ~ U(0.0, 0.3)
    # a_slope  ~ U(0.01, 0.9)

    prior_samples = np.random.uniform(
        low=(0.1, 0.5, 0.1, 0.05, 0.06, 0.0, 0.0, 0.01),
        high=(2.0, 3.0, 0.9, 0.6, 0.8, 0.3, 0.3, 0.9)
    )
    return prior_samples


def draw_prior_m6():
    """Draws samples from the prior distributions of m6."""

    # drift    ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 2.0)
    # beta     ~ U(0.1, 0.9)
    # mu_tau_e ~ U(0.05, 0.6)
    # tau_m    ~ U(0.06, 0.8)
    # sigma    ~ U(0.0, 0.3)
    # varsigma ~ U(0.0, 0.3)
    # lambda   ~ U(0.5, 4.0)

    prior_samples = np.random.uniform(
        low=(0.1, 0.5, 0.1, 0.05, 0.06, 0.0, 0.0, 0.5),
        high=(3.0, 3.0, 0.9, 0.6, 0.8, 0.3, 0.3, 4.0)
    )
    return prior_samples


def draw_prior_m7():
    """Draws samples from the prior distributions of m7."""

    # mu_drift ~ U(0.01, 3.0)
    # boundary ~ U(0.5, 2.0)
    # beta     ~ U(0.1, 0.9)
    # tau      ~ U(0.1, 1.0)
    # sigma    ~ U(0.0, 2.0)
    # eta      ~ U(0.0, 2.0)

    prior_samples = np.random.uniform(
        low=(0.01, 0.5, 0.1, 0.1, 0.0, 0.0),
        high=(3.0, 2.0, 0.9, 1.0, 2.0, 2.0)
    )
    return prior_samples


def draw_prior_m8():
    """Draws samples from the prior distributions of m8."""

    # mu_drift ~ U(0.0, 3.0)
    # boundary ~ U(0.2, 2.0)
    # tau      ~ U(0.1, 1.0)
    # sigma    ~ U(0.5, 4.0)
    # gamma    ~ U(-3.0, 3.0)
    # eta      ~ U(0.0, 2.0)

    prior_samples = np.random.uniform(
        low=(0.0, 0.2, 0.1, 0.0, -3.0, 0.0),
        high=(3.0, 2.0, 1.0, 2.0, 3.0, 2.0)
    )
    return prior_samples


def draw_prior_m9():
    """Draws samples from the prior distributions of m9."""

    # drift    ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 2.0)
    # beta     ~ U(0.1, 0.9)
    # t_e      ~ U(0.05, 0.6)
    # t_m      ~ U(0.06, 0.8)
    # sigma_e  ~ U(0.0, 0.3)

    prior_samples = np.random.uniform(
        low=(-3.0, 0.5, 0.1, 0.05, 0.06, 0.0),
        high=(3.0, 2.0, 0.9, 0.6, 0.8, 0.3)
    )
    return prior_samples


def draw_prior_m10():
    """Draws samples from the prior distributions of m10."""

    # drift    ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 2.0)
    # beta     ~ U(0.1, 0.9)
    # t_e      ~ U(0.05, 0.6)
    # t_m      ~ U(0.06, 0.8)
    # sigma_e  ~ U(0.0, 0.3)
    # gamma    ~ U(0.1, 4.0)

    prior_samples = np.random.uniform(
        low=(-3.0, 0.5, 0.1, 0.05, 0.06, 0.0, 0.1),
        high=(3.0, 2.0, 0.9, 0.6,  0.8,  0.3, 4.0)
    )
    return prior_samples


def draw_prior_m11():
    """Draws samples from the prior distributions of m11."""

    # drift    ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 4.0)
    # beta     ~ U(0.1, 0.9)
    # tau      ~ U(0.1, 1.0)
    # eta      ~ U(0.01, 2.0)

    prior_samples = np.random.uniform(
        low=(0.0, 0.5, 0.1, 0.1, 0.01),
        high=(3.0, 4.0, 0.9, 1.0, 2.0)
    )
    return prior_samples


def draw_prior_m12():
    """Draws samples from the prior distributions of m12."""

    # drift    ~ U(-3.0, 3.0)
    # boundary ~ U(0.5, 4.0)
    # beta     ~ U(0.1, 0.9)
    # tau      ~ U(0.1, 1.0)
    # sigma_e  ~ U(0.1, 4.0)
    # gamma    ~ U(0.5, 4.0)

    prior_samples = np.random.uniform(
        low=(0.1, 0.5, 0.1, 0.1, 0.1, 0.5),
        high=(3.0, 4.0, 0.9, 1.0, 4.0, 4.0)
    )
    return prior_samples
