MODES = [
    'expert',
    'learner',
    'direct_hybrid',
    'mmd_hybrid',
    'generative_hybrid'
]

MODE_NAMES = [
    'Expert',
    'Learner',
    'Hybrid (direct)',
    'Hybrid (joint)',
    'Hybrid (conditional)'
]

EMBEDDING_SETTINGS = {
    'non_linear': True,
    'non_linear_kwargs': dict(
        hidden_dims=[256, 128],
        activation='relu',
        dropout=0.05
    ),
}

# Names of the different generative models
MODEL_NAMES = [
    "m1a", "m1b", "m1c", "m2", "m3", "m4a", "m4b",
    "m5", "m6", "m7", "m8", "m9", "m10", "m11", "m12"
]

# Names of parameters of the different generative models
PARAMETER_NAMES = {
    "m1a": [r"$v$", r"$a$", r"$\beta$", r"$\mu_{encoding}$", r"$\mu_{motor}$", r"$\sigma$", r"$\sigma_{var}$"],
    "m1b": [r"$v$", r"$a$", r"$\beta$", r"$\mu_{encoding}$", r"$\mu_{motor}$", r"$\sigma$", r"$\sigma_{var}$"],
    "m1c": [r"$v$", r"$a$", r"$\beta$", r"$\mu_{encoding}$", r"$\mu_{motor}$", r"$\sigma$", r"$\sigma_{var}$"],
    "m2": [r"$v$", r"$a$", r"$\beta$", r"$\mu_{encoding}$", r"$\mu_{motor}$", r"$\sigma$", r"$\sigma_{var}$", r"$\gamma$"],
    "m3": [r"$v$", r"$a$", r"$\beta$", r"$\mu_{encoding}$", r"$\mu_{motor}$", r"$\sigma$", r"$\sigma_{var}$", r"$\theta$"],
    "m4a": [r"$v$", r"$a$", r"$\beta$", r"$\mu_{encoding}$", r"$\mu_{motor}$", r"$\tau$", r"$\sigma_e$", r"$\sigma_k$", r"$\sigma_{var}$", r"$k$",r"$\theta$"],
    "m4b": [r"$v$", r"$a$", r"$\beta$", r"$\mu_{encoding}$", r"$\mu_{motor}$", r"$\sigma_e$", r"$\sigma_{var}$", r"$\theta$"],
    "m5": [r"$v$", r"$a$", r"$\beta$", r"$\mu_{encoding}$", r"$\mu_{motor}$", r"$\sigma$", r"$\sigma_{var}$", r"$a_{slope}$"],
    "m6": [r"$v$", r"$a$", r"$\beta$", r"$\mu_{encoding}$", r"$\mu_{motor}$", r"$\sigma$", r"$\sigma_{var}$", r"$\lambda$"],
    "m7": [r"$\mu_v$", r"$a$", r"$\beta$", r"$\tau$", r"$\sigma$", r"$\eta$"],
    "m8": [r"$v$", r"$a$", r"$\tau$", r"$\sigma$", r"$\gamma$", r"$\eta$"],
    "m9": [r"$v$", r"$a$", r"$\beta$", r"$t_e$", r"$t_m$", r"$\sigma_e$"],
    "m10": [r"$v$", r"$a$", r"$\beta$", r"$t_e$", r"$t_m$", r"$\sigma_e$", r"$\gamma$"],
    "m11": [r"$v$", r"$a$", r"$\beta$", r"$ndt$", r"$\eta$"],
    "m12": [r"$v$", r"$a$", r"$\beta$", r"$ndt$", r"$\sigma_e$", r"$\gamma$"]
}

PARAMS_OF_INTEREST = {
    MODEL_NAMES[0]: [1, 5],
    MODEL_NAMES[1]: [5, 6],
    MODEL_NAMES[2]: [2, 5],
    MODEL_NAMES[3]: [3, 5],
    MODEL_NAMES[4]: [0, 2], 
    MODEL_NAMES[5]: [3, 10],
    MODEL_NAMES[6]: [5, 7],
    MODEL_NAMES[7]: [1, 7],
    MODEL_NAMES[8]: [1, 7],
    MODEL_NAMES[9]: [4, 5],
    MODEL_NAMES[10]: [1, 3],
    MODEL_NAMES[11]: [1, 5],
    MODEL_NAMES[12]: [1, 5],
    MODEL_NAMES[13]: [1, 3],
    MODEL_NAMES[14]: [0, 5],
}

SIMULATION_BUDGETS = [1000, 5000, 10000]

PLOTTING_SETTINGS = {
    'font_size_1': 24,
    'font_size_2': 20,
    'font_size_3': 16,
    'alpha': 0.75,
    'truth_color': "black",
    'post_color': '#440154',
    'prior_color': '#21918c',
    'font_type': "Palatino",
    'font_family': "serif",
    'fig_size': (18, 8),
    'grid_alpha': 0.3
}