import pickle

from tqdm import tqdm

from models import get_model
from settings import MODEL_NAMES

NUM_SIMULATIONS_TEST = 1000

if __name__ == '__main__':
    for model_type in tqdm(MODEL_NAMES):
        model = get_model(model_type)
        test_data = model(NUM_SIMULATIONS_TEST)
        with open(f'./simulations/test_{model_type}.pkl', 'wb+') as f:
            pickle.dump(test_data, f)
