import torch
import re
import matplotlib.pyplot as plt

pattern = re.compile(r"Frequency:\s*(\d+)")

frequencies = []
with open("freqs.txt", "r") as file:
    for line in file:
        match = pattern.search(line)
        if match:
            frequencies.append(int(match.group(1)))

# Create a PyTorch tensor from the list of frequencies
freq_tensor = torch.tensor(frequencies)
probs = freq_tensor/freq_tensor.sum()

print(probs.argmax())
print(probs.shape)

#torch.save(probs, 'probs.pt')




