from .q_learner import QLearner
from .noise_q_learner import QLearner as NoiseQLearner
from .wmad_q_learner import QLearner as WmadQLearner
from .coma_learner import COMALearner
from .actor_critic_learner import ActorCriticLearner
from .qtran_learner import QLearner as Qtranlearner
from .ppo_learner import PPOLearner as PPOLearner
from .wmad_ppo_learner import PPOLearner as WmadPPOLearner

REGISTRY = {}

REGISTRY["q_learner"] = QLearner
REGISTRY["noise_q_learner"] = NoiseQLearner
REGISTRY["wmad_q_learner"] = WmadQLearner
REGISTRY["coma_learner"] = COMALearner
REGISTRY["actor_critic_learner"] = ActorCriticLearner
REGISTRY["qtran_learner"] = Qtranlearner
REGISTRY["ppo_learner"] = PPOLearner
REGISTRY["wmad_ppo_learner"] = WmadPPOLearner
