# PCD Implementation for MMD Benchmark


This implementation inherits from `MMD` [1]. 



## Installation

Follow the setup steps from MMD as below. 

### Requirements
- [miniconda](https://docs.conda.io/projects/miniconda/en/latest/index.html)

### Steps

1. Create a conda environment and activate it:
    ```sh
    conda env create -f environment.yml
    conda activate pcdmmd
    ```
2. Install PyTorch. This may be different depending on your system. We used the following command:
    ```sh
    conda install pytorch==2.1.1 torchvision==0.16.1 torchaudio==2.1.1 pytorch-cuda=12.1 -c pytorch -c nvidia 
    ```
3. Install some local packages (modified version of [2, 3]):  
    ```sh
    cd deps/torch_robotics
    pip install -e .
    cd ../experiment_launcher
    pip install -e .
    cd ../motion_planning_baselines
    pip install -e .
    cd ../..
    ```
4. Install the `mmd` package:
    ```sh
    pip install -e .
    ```


## Planning with PCD-MMD


### Get the dataset

Download the sample datasets and models provided by MMD. 

```sh
conda activate pcdmmd
```

```sh
gdown --id 1Onw0s1pDsMLDfJVOAqmNme4eVVoAkkjz
tar -xJvf data_trajectories.tar.xz

gdown --id 1WO3tpvg-HU0m9RyDvGyfDamo7roBYMud
tar -xJvf data_trained_models.tar.xz
```

### Generating a Missing Dataset

Dataset for `DropRegion` is missing from the official release of MMD. 
Do the following to generate a few (all we need is some confiuration files actually):

```sh 
conda activate pcdmmd

python scripts/generate_data/launch_generate_trajectories.py
```


- The generated data will be saved in the `logs/` directory. In order to use the generated data, please move it to the `data_trajectories/` directory. Rename and reorganize the folder structure following other environments therein. 


### Running Inference

#### Inference Script

Launch planning by executing `scripts/inference/launch_pcdiff.py`. 
***Users need to check and adjust settings in the script***. 

```bash
conda activate pcdmmd

python python scripts/inference/launch_pcdiff.py --config pcdiff_empty.yaml -g coupling -p max_vel_admm -c "hinge_sqr_l2"  -r  --gpu-id 0  -m custom_comments
```
- `--config`: to designate config file for the task to run. See all under `configs/`. 
- `-g`: use coupling or not, should be one of {'coupling', 'vanilla'}. 
- `-p`: use projection or not, should be one of {'max_vel_admm', 'none'}. 
- `-c`: specify the cost function should be one of {'hinge_sqr_l2', 'sum_log_l2'}, corresponding to the SHD and LB cost specified in the paper, respectively. 
- `-r`: product all specified hyperparameters for multiruns. 
- `--gpu_id`: specify device number. 


Results will be saved under the `results/` directory.


---


## References

- [1] Shaoul Y, Mishani I, Vats S, Li J, Likhachev M. Multi-robot motion planning with diffusion models. ICLR. 2025. 
- [2] Carvalho J, Le AT, Baierl M, Koert D, Peters J. Motion planning diffusion: Learning and planning of robot motions with diffusion models. 2023 IEEE/RSJ International Conference on Intelligent Robots and Systems (IROS). 2023 Oct 1 (pp. 1916-1923). 
- [3] Le AT, Chalvatzaki G, Biess A, Peters JR. Accelerating motion planning via optimal transport. Advances in Neural Information Processing Systems. 2023 Dec 15;36:78453-82. 
