# Standard imports.

# Project includes.
from torch import fix
from mmd.common.experiments.experiment_utils import *
from inference_mmd import run_multi_agent_trial


def run_multi_agent_experiment(experiment_config: MultiAgentPlanningExperimentConfig):
    # Run the multi-agent planning experiment.
    startt = time.time()
    # Create the experiment config.
    experiment_config.time_str = datetime.now().strftime("%Y-%m-%d-%H-%M-%S")
    # Get single trial configs from the experiment config.
    single_trial_configs = experiment_config.get_single_trial_configs_from_experiment_config()
    # So let's run sequentially.
    for single_trial_config in single_trial_configs:
        print(single_trial_config)
        try:
            run_multi_agent_trial(single_trial_config)

            # Aggregate and save data on every step. This is not needed (can be done once at the end).
            combine_and_save_results_for_experiment(experiment_config)
        except Exception as e:
            print("Error in run_multi_agent_experiment: ", e)
            # Save to a file.
            with open(f"error_{experiment_config.time_str}.txt", "a") as f:
                f.write(str(e))
                f.write("This is for single_trial_config: ")
                f.write(str(single_trial_config))
                f.write("\n")
            continue

    # Print the runtime.
    print("Runtime: ", time.time() - startt)
    print("Run: OK.")


if __name__ == "__main__":
    # Instance names. These dictate the maps and start/goals.
    # Create an experiment config.
    experiment_config = MultiAgentPlanningExperimentConfig()
    # Set the experiment config.
    experiment_config.num_agents_l = [4]

    # Single tile.
    # experiment_config.instance_name = "EnvConveyor2DRobotPlanarDiskRandom"
    experiment_config.instance_name = "EnvEmpty2DRobotPlanarDiskRandom"
    # experiment_config.instance_name = "EnvHighways2DRobotPlanarDiskRandom"
    # experiment_config.instance_name = "EnvDropRegion2DRobotPlanarDiskRandom"


    experiment_config.stagger_start_time_dt = 0
    experiment_config.multi_agent_planner_class_l = ["CBS",]  
    experiment_config.single_agent_planner_class = "MPD"
    experiment_config.runtime_limit = 60 
    experiment_config.num_trials_per_combination = 100
    experiment_config.render_animation = False
    # Run the experiment.
    run_multi_agent_experiment(experiment_config)

