# Diffusion-Policy-based PCD Implementation

**Table of Contents**
- [PushT: Diffusion-Policy-based Implementation](#ltldog-diffusion-policy-based-implementation)
    - [Installation](#installation)
    - [Play with the Env (Optional)](#play-with-the-env-optional)
        - [PushT Task Demo](#pusht-task-demo)
    - [Pretrained Weights](#pretrained-weights)
    - [Inference](#inference)


## Installation

1. Create a Conda environment with `conda_environment.yaml` (we also recommend Mambaforge) 

    ```sh
    mamba env create -f conda_environment.yaml
    # Or you can use conda
    # conda env create -f conda_environment.yaml
    ```

    Downgrade huggingface-hub for compatibility

    ```sh
    pip install "huggingface_hub<0.14.0"
    ```

2. Install `diffusion_policy` as a package in your newly created environment

    ```sh
    mamba activate pcdp 
    pip install -e . 
    ```


## Play with the Env (Optional)

### PushT Task Demo

The demo script inherits from Diffusion Policy. 
Familiarize yourself with the environment by 

```sh
python demo_pusht.py --help
```


## Pretrained Weights

- Pretained weights are from <span style="font-variant: small-caps;">LTLDoG</span> [1]. 
- Move checkpoints to `data/pretrained/diffusion` for inference. 
- See [Inference Configs](#inference-configs) for configuring the weights path. 

### Configs

The configuration setting pipeline inherits from <span style="font-variant: small-caps;">DiffusionPolicy</span> [2] and <span style="font-variant: small-caps;">LTLDoG</span> [1]. 



## Inference

Evaluation scripts are under `scripts/`:

- We provide a sequential executing scripts that could be used to run multiple times (for different parameters). 
- Run `eval_H16_pusht_seq.py` with proper args for inference. ***Set up hyperparameters in the script first***. 
- Calling example: 

    ```sh
    python scripts/eval_H16_seq.py  -r  --gpu-id 0  --guider coupling  --cost-func-key "dpp"  --projector max_vel_admm  -m "custom_comments"
    ```

    - Args: 
        - `--guider` should be one of {'vanilla', 'coupling', 'coupling_ps'}, corresponding to no coupling at all, standard coupling costs, or posteior sampling cost variants. 
        - `--cost-func-key` should be in {'dpp', 'sum_log_l2'}. 
        - `--projector` should be one of {'none', 'max_vel_admm'}. 
        - `-r` means running with the *Cartesian product* of all hyperparameters set in the script. See detailed logic in the script. 

- Results are recorded by default under `logs/tests/`. 


### Inference Configs

- Configuration files are at `diffusion_policy/config/eval_*.yaml`. You may need to change the `diffusion_checkpoint` field. 


## References

- [1] Feng Z, Luan H, Goyal P, Soh H. LTLDoG: Satisfying Temporally-Extended Symbolic Constraints for Safe Diffusion-Based Planning, *IEEE Robotics and Automation Letters*, vol. 9, no. 10, pp. 8571-8578, Oct. 2024. 
- [2] Chi C, Xu Z, Feng S, Cousineau E, Du Y, Burchfiel B, Tedrake R, Song S. Diffusion Policy: Visuomotor policy learning via action diffusion. *The International Journal of Robotics Research*. 2023 Jun:02783649241273668. 

