/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResTypeSpec;
import brut.androlib.res.data.arsc.ARSCData;
import brut.androlib.res.data.arsc.ARSCHeader;
import brut.androlib.res.data.arsc.EntryData;
import brut.androlib.res.data.arsc.FlagsOffset;
import brut.androlib.res.data.value.ResArrayValue;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResEnumAttr;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResFlagsAttr;
import brut.androlib.res.data.value.ResIntBasedValue;
import brut.androlib.res.data.value.ResPluralsValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;
import brut.androlib.res.data.value.ResStyleValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.decoder.StringBlock;
import brut.util.ExtDataInputStream;
import com.google.common.io.CountingInputStream;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class ARSCDecoder {
    public static final Logger LOGGER = Logger.getLogger(ARSCDecoder.class.getName());
    public final ExtDataInputStream mIn;
    public final ResTable mResTable;
    public final ArrayList mFlagsOffsets;
    public final boolean mKeepBroken;
    public final Config mConfig;
    public final LinkedHashMap mMissingResSpecMap;
    public final HashMap mResTypeSpecs;
    public ARSCHeader mHeader;
    public StringBlock mTableStrings;
    public StringBlock mTypeNames;
    public StringBlock mSpecNames;
    public ResPackage mPkg;
    public ResTypeSpec mTypeSpec;
    public ResType mType;
    public int mResId;
    public int mTypeIdOffset;

    public ARSCDecoder(InputStream object, ResTable resTable, boolean bl, boolean bl2) {
        ExtDataInputStream extDataInputStream;
        LittleEndianDataInputStream littleEndianDataInputStream;
        CountingInputStream countingInputStream;
        CountingInputStream countingInputStream2 = countingInputStream;
        countingInputStream = new CountingInputStream((InputStream)object);
        object = littleEndianDataInputStream;
        littleEndianDataInputStream = new LittleEndianDataInputStream(countingInputStream2);
        ExtDataInputStream extDataInputStream2 = extDataInputStream;
        extDataInputStream = new ExtDataInputStream((DataInput)object, countingInputStream2);
        this.mIn = extDataInputStream2;
        this.mResTable = resTable;
        if (bl) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        } else {
            object = null;
        }
        ARSCDecoder aRSCDecoder = this;
        this.mFlagsOffsets = object;
        this.mKeepBroken = bl2;
        aRSCDecoder.mConfig = resTable.mConfig;
        aRSCDecoder.mMissingResSpecMap = new LinkedHashMap();
        aRSCDecoder.mResTypeSpecs = new HashMap();
    }

    public static char[] unpackLanguageOrRegion(byte by, byte by2, char c) {
        if ((by >> 7 & 1) == 1) {
            byte by3 = by;
            byte by4 = by2;
            by2 = (byte)(by4 & 0x1F);
            byte by5 = by = (byte)(((by4 & 0xE0) >> 5) + ((by & 3) << 3));
            by = (byte)(by2 + c);
            by2 = (byte)(by5 + c);
            c = (char)(((by3 & 0x7C) >> 2) + c);
            return new char[]{(char)by, (char)by2, c};
        }
        by = by;
        by2 = by2;
        return new char[]{(char)by, (char)by2};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ARSCData decode() {
        FlagsOffset[] flagsOffsetArray;
        block3: {
            try {
                ResPackage[] resPackageArray = resPackageArray.readResourceTable();
                flagsOffsetArray = resPackageArray.mFlagsOffsets;
                if (resPackageArray.mFlagsOffsets == null) break block3;
            }
            catch (IOException iOException) {
                throw new AndrolibException("Could not decode arsc file", iOException);
            }
            flagsOffsetArray = flagsOffsetArray.toArray(new FlagsOffset[0]);
            return new ARSCData(resPackageArray, flagsOffsetArray);
        }
        flagsOffsetArray = null;
        return new ARSCData(resPackageArray, flagsOffsetArray);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final ResPackage[] readResourceTable() {
        var1_1 = v0;
        v0 = new LinkedHashSet<ResPackage>();
        var2_2 = 1;
        block29: while (true) {
            block117: {
                block118: {
                    block119: {
                        var3_5 = this.mIn;
                        var4_20 = var3_5.mCountIn.count;
                        try {
                            var6_39 = var3_5.mDelegate.readShort();
                        }
                        catch (EOFException v3) {
                            var7_44 = v4;
                            var3_6 = 0;
                            var4_21 = 0;
                            var5_30 = var3_5.mCountIn.count;
                            v4 = new ARSCHeader(-1, var3_6, var4_21, var5_30);
                        }
                        var7_44 = v1;
                        v2 = var3_5;
                        var3_6 = v2.mDelegate.readShort();
                        v1 = new ARSCHeader(var6_39, var3_6, v2.mDelegate.readInt(), var4_20);
                        this.mHeader = var7_44;
                        var3_7 = ARSCDecoder.LOGGER;
                        var4_22 = var2_2++;
                        var5_31 = this.mIn.mCountIn.count;
                        var6_40 = this.mHeader.type;
                        var7_44 = this.mHeader.chunkSize;
                        var3_7.fine(String.format("Chunk #%d start=0x%08x type=0x%04x chunkSize=0x%08x", new Object[]{var4_22, var5_31, var6_40, var7_44}));
                        var4_23 = this.mHeader.type;
                        if (var4_23 == 0) break block117;
                        if (var4_23 == 1) break block118;
                        if (var4_23 == 2) break block119;
                        switch (var4_23) {
                            default: {
                                if (var4_23 != -1) {
                                    v5 = var3_7;
                                    var2_3 = (short)var4_23;
                                    v6 = new Object[1];
                                    var3_7 = v6;
                                    v6[0] = var2_3;
                                    v5.severe(String.format("Unknown chunk type: %04x", (Object[])var3_7));
                                }
                                if (this.mConfig.mDecodeResolveMode == 1 && (var2_4 = this.mPkg) != null && var2_4.mResSpecs.size() > 0) {
                                    for (Object var3_7 : this.mMissingResSpecMap.keySet()) {
                                        var4_24 = var3_7.intValue();
                                        var3_7 = (Integer)this.mMissingResSpecMap.get(var3_7);
                                        var3_7.getClass();
                                        var5_31 = "APKTOOL_DUMMY_" + Integer.toHexString(var4_24);
                                        var6_40 = v7;
                                        v7 = new ResID(var4_24);
                                        var4_25 = v8;
                                        var3_7 = (ResTypeSpec)this.mResTypeSpecs.get(var3_7);
                                        v8 = new ResResSpec((ResID)var6_40, (String)var5_31, this.mPkg, (ResTypeSpec)var3_7);
                                        if (this.mPkg.mResSpecs.containsKey(var6_40)) continue;
                                        if (this.mPkg.mResSpecs.put(var6_40, var4_25) == null) {
                                            var4_25.mType.addResSpec(var4_25);
                                            var3_7 = this.mPkg;
                                            var5_31 = v9;
                                            v9 = new ResConfigFlags();
                                            var6_40 = (ResType)var3_7.mConfigs.get(var5_31);
                                            if (var6_40 == null) {
                                                var6_40 = v10;
                                                v10 = new ResType((ResConfigFlags)var5_31);
                                                var3_7.mConfigs.put(var5_31, var6_40);
                                            }
                                            var3_7 = v11;
                                            v11 = new ResReferenceValue(this.mPkg, "");
                                            var5_31 = v12;
                                            var6_40.addResource(new ResResource((ResType)var6_40, var4_25, (ResValue)var3_7), false);
                                            var4_25.addResource((ResResource)var5_31, false);
                                            continue;
                                        }
                                        throw new AndrolibException("Multiple resource specs: " + var4_25);
                                    }
                                }
                                return var1_1.toArray(new ResPackage[0]);
                            }
                            case 518: {
                                var3_8 = this.mIn.mDelegate.readInt();
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                var4_23 = 0;
                                while (true) {
                                    if (var4_23 >= var3_8) continue block29;
                                    var5_31 = this.mIn.mDelegate.readInt();
                                    var6_40 = this.mIn.mDelegate.readInt();
                                    ARSCDecoder.LOGGER.fine(String.format("Staged alias: 0x%08x -> 0x%08x", new Object[]{var5_31, var6_40}));
                                    ++var4_23;
                                }
                            }
                            case 517: {
                                this.checkChunkType(517);
                                this.mIn.mDelegate.readInt();
                                var3_9 = this.mIn.mDelegate.readInt();
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                var4_23 = 0;
                                while (true) {
                                    if (var4_23 >= var3_9) continue block29;
                                    var5_31 = this.mIn.mDelegate.readInt();
                                    ARSCDecoder.LOGGER.fine(String.format("Skipping overlay (%h)", new Object[]{var5_31}));
                                    ++var4_23;
                                }
                            }
                            case 516: {
                                v13 = var3_7;
                                this.checkChunkType(516);
                                var3_7 = this.mIn.readNullEndedString(256);
                                var4_26 = this.mIn.readNullEndedString(256);
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                v14 = var5_31 = v15;
                                var5_31("Overlay name: \"");
                                v14.append((String)var3_7);
                                v14.append("\", actor: \"");
                                v15.append(var4_26);
                                v15.append("\")");
                                v13.fine(v15.toString());
                                continue block29;
                            }
                            case 515: {
                                this.checkChunkType(515);
                                var3_10 = this.mIn.mDelegate.readInt();
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                var4_23 = 0;
                                while (true) {
                                    if (var4_23 >= var3_10) continue block29;
                                    var5_31 = this.mIn.readNullEndedString(128);
                                    var6_40 = this.mIn.mDelegate.readInt();
                                    v16 = new Object[2];
                                    var7_44 = v16;
                                    v16[0] = var5_31;
                                    v16[1] = var6_40;
                                    ARSCDecoder.LOGGER.info(String.format("Decoding Shared Library (%s), pkgId: %d", var7_44));
                                    ++var4_23;
                                }
                            }
                            case 514: {
                                this.checkChunkType(514);
                                var3_11 = this.mIn.mDelegate.readUnsignedByte();
                                this.mIn.skipBytes(1);
                                this.mIn.skipBytes(2);
                                var4_23 = this.mIn.mDelegate.readInt();
                                var5_31 = this.mFlagsOffsets;
                                if (var5_31 != null) {
                                    var5_31.add(new FlagsOffset((int)this.mIn.mCountIn.count, var4_23));
                                }
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                this.mIn.skipBytes(var4_23 * 4);
                                var4_27 = v17;
                                var3_12 = this.mTypeNames.getString(var3_11 - 1);
                                v17 = new ResTypeSpec(var3_11, (String)var3_12);
                                this.mTypeSpec = var4_27;
                                var5_31 = this.mPkg;
                                if (var5_31.mTypes.containsKey(var3_12)) {
                                    ResPackage.LOGGER.warning("Multiple types detected! " + var4_27 + " ignored!");
                                } else {
                                    var5_31.mTypes.put(var3_12, var4_27);
                                }
                                var3_12 = this.mTypeSpec;
                                this.mResTypeSpecs.put(var3_12.mId, var3_12);
                                continue block29;
                            }
                            case 513: {
                                this.checkChunkType(513);
                                var4_23 = this.mIn.mDelegate.readUnsignedByte() - this.mTypeIdOffset;
                                if (this.mResTypeSpecs.containsKey(var4_23)) {
                                    this.mTypeSpec = (ResTypeSpec)this.mResTypeSpecs.get(var4_23);
                                } else {
                                    var5_31 = v18;
                                    v18 = new ResTypeSpec(var4_23, this.mTypeNames.getString(var4_23 - 1));
                                    this.mTypeSpec = var5_31;
                                    this.mResTypeSpecs.put(var4_23, var5_31);
                                    var5_31 = this.mPkg;
                                    var6_40 = this.mTypeSpec;
                                    if (var5_31.mTypes.containsKey(var6_40.mName)) {
                                        ResPackage.LOGGER.warning("Multiple types detected! " + var6_40 + " ignored!");
                                    } else {
                                        var5_31.mTypes.put(var6_40.mName, var6_40);
                                    }
                                }
                                this.mResId = this.mResId & -16777216 | this.mTypeSpec.mId << 16;
                                var5_32 = this.mIn.mDelegate.readByte();
                                this.mIn.skipBytes(2);
                                var6_41 = this.mIn.mDelegate.readInt();
                                var7_45 = this.mIn.mDelegate.readInt();
                                var8_54 = this.mIn.mDelegate.readInt();
                                var9_61 = 8;
                                if (var8_54 < 8) ** GOTO lbl581
                                var10_65 = 0;
                                var11_75 = this.mIn.mDelegate.readShort();
                                var12_78 = this.mIn.mDelegate.readShort();
                                var13_80 /* !! */  = new char[]{};
                                var14_86 /* !! */  = new char[]{};
                                if (var8_54 >= 12) {
                                    var13_80 /* !! */  = ARSCDecoder.unpackLanguageOrRegion(this.mIn.mDelegate.readByte(), this.mIn.mDelegate.readByte(), 'a');
                                    var14_86 /* !! */  = ARSCDecoder.unpackLanguageOrRegion(this.mIn.mDelegate.readByte(), this.mIn.mDelegate.readByte(), '0');
                                    var9_61 = 12;
                                }
                                var15_88 = 0;
                                var16_90 = 0;
                                if (var8_54 >= 14) {
                                    var15_88 = this.mIn.mDelegate.readByte();
                                    var16_90 = this.mIn.mDelegate.readByte();
                                    var9_61 = 14;
                                }
                                var17_93 = 0;
                                if (var8_54 >= 16) {
                                    var17_93 = this.mIn.mDelegate.readUnsignedShort();
                                    var9_61 = 16;
                                }
                                var18_96 = 0;
                                var19_97 = 0;
                                var20_99 = 0;
                                var21_101 = 0;
                                if (var8_54 >= 20) {
                                    var18_96 = this.mIn.mDelegate.readByte();
                                    var19_97 = this.mIn.mDelegate.readByte();
                                    var20_99 = this.mIn.mDelegate.readByte();
                                    var21_101 = this.mIn.mDelegate.readByte();
                                    var9_61 = 20;
                                }
                                var22_102 = 0;
                                var23_104 = 0;
                                var24_105 = 0;
                                if (var8_54 >= 28) {
                                    var22_102 = this.mIn.mDelegate.readShort();
                                    var23_104 = this.mIn.mDelegate.readShort();
                                    var24_105 = this.mIn.mDelegate.readShort();
                                    this.mIn.skipBytes(2);
                                    var9_61 = 28;
                                }
                                var25_107 = false;
                                var26_108 = 0;
                                var27_109 = 0;
                                if (var8_54 >= 32) {
                                    var25_107 = this.mIn.mDelegate.readByte();
                                    var26_108 = this.mIn.mDelegate.readByte();
                                    var27_109 = this.mIn.mDelegate.readShort();
                                    var9_61 = 32;
                                }
                                var28_110 = 0;
                                var29_111 = 0;
                                if (var8_54 >= 36) {
                                    var28_110 = this.mIn.mDelegate.readShort();
                                    var29_111 = this.mIn.mDelegate.readShort();
                                    var9_61 = 36;
                                }
                                var30_112 = null;
                                var31_113 = null;
                                if (var8_54 >= 48) {
                                    var30_112 = this.readVariantLengthString(4).toCharArray();
                                    var31_113 = this.readVariantLengthString(8).toCharArray();
                                    var9_61 = 48;
                                }
                                var32_114 = 0;
                                var33_115 = 0;
                                if (var8_54 >= 52) {
                                    var32_114 = this.mIn.mDelegate.readByte();
                                    var33_115 = this.mIn.mDelegate.readByte();
                                    this.mIn.skipBytes(2);
                                    var9_61 = 52;
                                }
                                var34_116 = null;
                                if (var8_54 >= 60) {
                                    var34_116 = this.readVariantLengthString(8).toCharArray();
                                    var9_61 = 60;
                                }
                                if ((var35_117 = var8_54 - 64) > 0) {
                                    v19 = var35_117;
                                    var9_62 /* !! */  = new byte[v19];
                                    var35_117 = var9_61 + v19;
                                    this.mIn.mDelegate.readFully(var9_62 /* !! */ );
                                    var36_118 = v20;
                                    if (new BigInteger(1, var9_62 /* !! */ ).equals(BigInteger.ZERO)) {
                                        v21 = var3_7;
                                        var3_7 = 64;
                                        v22 = new Object[1];
                                        var9_62 /* !! */  = (byte[])v22;
                                        v22[0] = var3_7;
                                        v21.fine(String.format("Config flags size > %d, but exceeding bytes are all zero, so it should be ok.", var9_62 /* !! */ ));
                                        var9_61 = var35_117;
                                    } else {
                                        v23 = var3_7;
                                        var3_7 = 64;
                                        var9_62 /* !! */  = (byte[])var8_54;
                                        v24 = new Object[3];
                                        var10_66 = v24;
                                        v24[0] = var3_7;
                                        v24[1] = var9_62 /* !! */ ;
                                        v24[2] = var36_118;
                                        v23.warning(String.format("Config flags size > %d. Size = %d. Exceeding bytes: 0x%X.", var10_66));
                                        var10_65 = 1;
                                        var9_61 = var35_117;
                                    }
                                }
                                if ((var3_13 = var8_54 - var9_61) > 0) {
                                    this.mIn.skipBytes(var3_13);
                                }
                                var3_14 = v25;
                                v25 = new ResConfigFlags(var11_75, (short)var12_78, var13_80 /* !! */ , var14_86 /* !! */ , (byte)var15_88, var16_90, var17_93, (byte)var18_96, var19_97, var20_99, (byte)var21_101, var22_102, (short)var23_104, var24_105, (byte)var25_107, var26_108, var27_109, var28_110, var29_111, var30_112, var31_113, var32_114, var33_115, var34_116, var8_54, (boolean)var10_65);
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                var8_54 = (var5_32 & 2) != 0 ? 1 : 0;
                                var5_32 = (var5_32 & 1) != 0 ? 1 : 0;
                                if (var5_32 != 0) {
                                    var9_63 = this.mResTable;
                                    if (!var9_63.mMainPkgLoaded) {
                                        var9_63.mApkInfo.sparseResources = var9_64 = true;
                                    }
                                }
                                var9_60 = v26;
                                v26 = new LinkedHashMap<Integer, Integer>();
                                for (var10_65 = 0; var10_65 < var6_41; ++var10_65) {
                                    if (var5_32 != 0) {
                                        v27 = var9_60;
                                        v28 = this.mIn.mDelegate.readUnsignedShort();
                                        v29 = this.mIn;
lbl304:
                                        // 2 sources

                                        while (true) {
                                            v30 = v29.mDelegate.readUnsignedShort();
lbl306:
                                            // 2 sources

                                            while (true) {
                                                continue;
                                                break;
                                            }
                                            break;
                                        }
                                    }
                                    if (var8_54 != 0) {
                                        v27 = var9_60;
                                        v28 = var10_65;
                                        v29 = this.mIn;
                                        ** continue;
                                    }
                                    v27 = var9_60;
                                    v28 = var10_65;
                                    v30 = this.mIn.mDelegate.readInt();
                                    ** continue;
                                    v27.put(v28, v30);
                                }
                                if (var3_14.mIsInvalid) {
                                    var5_33 = this.mTypeSpec.mName + var3_14.mQualifiers;
                                    if (this.mKeepBroken) {
                                        ARSCDecoder.LOGGER.warning("Invalid config flags detected: " + var5_33);
                                    } else {
                                        ARSCDecoder.LOGGER.warning("Invalid config flags detected. Dropping resources: " + var5_33);
                                    }
                                }
                                if (var3_14.mIsInvalid && !this.mKeepBroken) {
                                    var3_14 = null;
                                } else {
                                    var5_34 = this.mPkg;
                                    var10_67 = (ResType)var5_34.mConfigs.get(var3_14);
                                    if (var10_67 == null) {
                                        v31 = var5_34;
                                        var5_34 = v32;
                                        v32 = new ResType((ResConfigFlags)var3_14);
                                        v31.mConfigs.put(var3_14, var5_34);
                                        var3_14 = var5_34;
                                    } else {
                                        var3_14 = var10_67;
                                    }
                                }
                                this.mType = var3_14;
                                var3_15 = var8_54 != 0 ? 65535 : -1;
                                var7_46 = this.mHeader.startPosition + (long)var7_45;
                                var5_35 = this.mIn;
                                var10_68 = var5_35.mCountIn.count;
                                if (var10_68 < var7_46) {
                                    var7_46 = var5_35.skip(var7_46 - var10_68);
                                    var5_35 = var7_46;
                                    v33 = new Object[1];
                                    var7_47 = v33;
                                    v33[0] = var5_35;
                                    ARSCDecoder.LOGGER.fine(String.format("Skipping: %d byte(s) to align with ResTable_entry start.", var7_47));
                                }
                                block37: for (Integer v34 : var9_60.keySet()) {
                                    var7_48 = v34;
                                    this.mResId = this.mResId & -65536 | var7_48;
                                    if ((Integer)var9_60.get(v34) == var3_15) {
                                        while (true) {
                                            var7_49 = this.mResId;
                                            this.mMissingResSpecMap.put(var7_49, var4_23);
                                            continue block37;
                                            break;
                                        }
                                    }
                                    var8_55 = this.mIn;
                                    if (var8_55.mCountIn.count == this.mHeader.endPosition) {
                                        var3_15 = var6_41 - var7_48;
                                        var3_16 = var3_15;
                                        var4_28 = this.mTypeSpec.mName;
                                        ARSCDecoder.LOGGER.warning(String.format("End of chunk hit. Skipping remaining entries (%d) in type: %s", new Object[]{var3_16, var4_28}));
                                        break;
                                    }
                                    var7_48 = var8_55.mDelegate.readUnsignedShort();
                                    var8_56 = this.mIn.mDelegate.readShort();
                                    var10_69 = (var8_56 & 1) != 0;
                                    var11_75 = (var8_56 & 8) != 0 ? 1 : 0;
                                    var12_78 = this.mIn.mDelegate.readInt();
                                    if (var12_78 == -1 && var11_75 == 0) {
                                        while (true) {
                                            var7_50 = null;
                                            break;
                                        }
                                    } else {
                                        if (var11_75 != 0) {
                                            v35 = this.mResTable;
                                            var13_80 /* !! */  = (char[])v35;
                                            if (!v35.mMainPkgLoaded) {
                                                var13_80 /* !! */ .mApkInfo.compactEntries = var13_81 = true;
                                            }
                                        }
                                        if (var11_75 != 0) {
                                            v36 = (byte)(var8_56 >> 8 & 255);
                                            var8_56 = v36;
                                            if (v36 == 3) {
                                                var8_57 = this.mPkg.getValueFactory();
                                                var10_70 = this.mTableStrings.getHTML(var12_78);
                                                var8_57.getClass();
                                                if (var10_70 == null) {
                                                    var8_57 = v37;
                                                    v37 = new ResFileValue(var12_78, "");
                                                } else if (var10_70.startsWith("res/")) {
                                                    var8_57 = v38;
                                                    v38 = new ResFileValue(var12_78, var10_70);
                                                } else if (!var10_70.startsWith("r/") && !var10_70.startsWith("R/")) {
                                                    var8_57 = v39;
                                                    v39 = new ResStringValue(var12_78, var10_70);
                                                } else {
                                                    var8_57 = v40;
                                                    v40 = new ResFileValue(var12_78, var10_70);
                                                }
                                            } else {
                                                var8_57 = this.mPkg.getValueFactory().factory(null, var8_56, var12_78);
                                            }
                                        } else if (var10_69) {
                                            var7_48 = this.mIn.mDelegate.readInt();
                                            var8_56 = this.mIn.mDelegate.readInt();
                                            var10_71 = this.mPkg.getValueFactory();
                                            var11_76 = new Pair[var8_56];
                                            for (var13_82 = 0; var13_82 < var8_56; ++var13_82) {
                                                var14_87 = this.mIn.mDelegate.readInt();
                                                var15_89 = this.readValue();
                                                if (var15_89 == null) continue;
                                                if (!(var15_89 instanceof ResScalarValue)) {
                                                    var16_91 = v41;
                                                    v42 = var15_89;
                                                    var15_89 = v42.toString();
                                                    v41 = new ResStringValue(v42.mRawIntValue, (String)var15_89);
                                                    var15_89 = var16_91;
                                                }
                                                var11_76[var13_82] = Pair.of(var14_87, (ResScalarValue)var15_89);
                                            }
                                            var13_83 = this.mTypeSpec;
                                            var14_86 /* !! */  = null;
                                            var15_88 = 0;
                                            var16_92 = v43;
                                            v43 = new ResReferenceValue(var10_71.mPackage, var7_48, (String)var14_86 /* !! */ , (boolean)var15_88);
                                            if (var8_56 == 0) {
                                                var7_51 = v44;
                                                v44 = new ResBagValue(var16_92);
                                                var8_57 = var7_51;
                                            } else {
                                                var7_51 = var13_83.mName;
                                                var7_51.getClass();
                                                var13_84 = -1;
                                                switch (var7_51.hashCode()) {
                                                    default: {
                                                        break;
                                                    }
                                                    case 93090393: {
                                                        if (!var7_51.equals("array")) break;
                                                        var13_84 = 3;
                                                        break;
                                                    }
                                                    case 3004913: {
                                                        if (!var7_51.equals("attr")) break;
                                                        var13_84 = 2;
                                                        break;
                                                    }
                                                    case -475309713: {
                                                        if (!var7_51.equals("plurals")) break;
                                                        var13_84 = 1;
                                                        break;
                                                    }
                                                    case -576469755: {
                                                        if (!var7_51.equals("^attr-private")) break;
                                                        var13_84 = 0;
                                                    }
                                                }
                                                switch (var13_84) {
                                                    default: {
                                                        if (var7_51.startsWith("style")) {
                                                            var7_51 = v45;
                                                            v45 = new ResStyleValue(var16_92, var11_76, var10_71);
                                                            var8_57 = var7_51;
                                                            break;
                                                        }
                                                        throw new AndrolibException("unsupported res type name for bags. Found: ".concat((String)var7_51));
                                                    }
                                                    case 3: {
                                                        var7_51 = v46;
                                                        v46 = new ResArrayValue(var16_92, var11_76);
                                                        var8_57 = var7_51;
                                                        break;
                                                    }
                                                    case 1: {
                                                        var7_51 = v47;
                                                        v47 = new ResPluralsValue(var16_92, var11_76);
                                                        var8_57 = var7_51;
                                                        break;
                                                    }
                                                    case 0: 
                                                    case 2: {
                                                        var7_51 = null;
                                                        var13_85 = null;
                                                        var14_86 /* !! */  = null;
                                                        block41: for (var15_88 = 1; var15_88 < var8_56; ++var15_88) {
                                                            var17_95 = (ImmutablePair)var11_76[var15_88];
                                                            switch ((Integer)var17_95.left) {
                                                                default: {
                                                                    break block41;
                                                                }
                                                                case 0x1000003: {
                                                                    var14_86 /* !! */  = (char[])(((ResScalarValue)var17_95.right).mRawIntValue != 0);
                                                                    continue block41;
                                                                }
                                                                case 0x1000002: {
                                                                    var13_85 = ((ResScalarValue)var17_95.right).mRawIntValue;
                                                                    continue block41;
                                                                }
                                                                case 0x1000001: {
                                                                    var7_51 = ((ResScalarValue)var17_95.right).mRawIntValue;
                                                                }
                                                            }
                                                        }
                                                        var17_93 = ((ResScalarValue)((ImmutablePair)var11_76[0]).right).mRawIntValue;
                                                        var18_96 = var17_93 & 65535;
                                                        if (var15_88 == var8_56) {
                                                            var8_57 = v48;
                                                            v48 = new ResAttr(var16_92, var18_96, (Integer)var7_51, var13_85, (Boolean)var14_86 /* !! */ );
                                                            break;
                                                        }
                                                        var19_98 = var16_92.mPackage;
                                                        var20_100 = new Pair[var8_56 - var15_88];
                                                        var21_101 = 0;
                                                        while (var15_88 < var8_56) {
                                                            var22_103 = (ImmutablePair)var11_76[var15_88];
                                                            var23_104 = (Integer)var22_103.left;
                                                            var19_98.mSynthesizedRes.add(new ResID(var23_104));
                                                            var24_106 = null;
                                                            var25_107 = false;
                                                            var20_100[var21_101] = Pair.of(new ResReferenceValue(var10_71.mPackage, var23_104, var24_106, var25_107), (ResScalarValue)var22_103.right);
                                                            ++var15_88;
                                                            ++var21_101;
                                                        }
                                                        var8_56 = var17_93 & 0xFF0000;
                                                        if (var8_56 != 65536) {
                                                            if (var8_56 == 131072) {
                                                                var8_57 = v49;
                                                                v49 = new ResFlagsAttr(var16_92, var18_96, (Integer)var7_51, var13_85, (Boolean)var14_86 /* !! */ , var20_100);
                                                                break;
                                                            }
                                                            throw new AndrolibException("Could not decode attr value");
                                                        }
                                                        var8_57 = v50;
                                                        v50 = new ResEnumAttr(var16_92, var18_96, (Integer)var7_51, var13_85, (Boolean)var14_86 /* !! */ , var20_100);
                                                    }
                                                }
                                            }
                                            var7_48 = var12_78;
                                        } else {
                                            var8_57 = this.readValue();
                                            var7_48 = var12_78;
                                        }
                                        if (var8_57 == null) ** continue;
                                        var10_72 = v51;
                                        new EntryData().specNamesId = var7_48;
                                        new EntryData().value = var8_57;
                                        var7_50 = var10_72;
                                    }
                                    if (var7_50 == null) ** continue;
                                    v52 = var7_50;
                                    var7_52 = v52.specNamesId;
                                    var8_58 = v52.value;
                                    if (this.mTypeSpec.mName.equals("string") && var8_58 instanceof ResFileValue) {
                                        var10_73 = v53;
                                        v54 = var8_58;
                                        var8_58 = ((ResFileValue)v54).mPath;
                                        v53 = new ResStringValue(((ResFileValue)v54).mRawIntValue, (String)var8_58);
                                        var8_58 = var10_73;
                                    }
                                    if (this.mType == null) continue;
                                    var10_74 = v55;
                                    v55 = new ResID(this.mResId);
                                    if (!this.mPkg.mResSpecs.containsKey(var10_74)) ** GOTO lbl548
                                    var7_53 = (ResResSpec)this.mPkg.mResSpecs.get(var10_74);
                                    if (var7_53 == null) {
                                        throw new UndefinedResObjectException("resource spec: " + var10_74);
                                    }
                                    ** GOTO lbl555
lbl548:
                                    // 1 sources

                                    var11_77 = v56;
                                    var7_53 = this.mSpecNames.getString(var7_52);
                                    var12_79 = this.mTypeSpec;
                                    v56 = new ResResSpec((ResID)var10_74, (String)var7_53, this.mPkg, var12_79);
                                    if (this.mPkg.mResSpecs.put(var10_74, var11_77) != null) ** GOTO lbl571
                                    this.mTypeSpec.addResSpec(var11_77);
                                    var7_53 = var11_77;
lbl555:
                                    // 2 sources

                                    v57 = this.mType;
                                    var10_74 = new ResResource(v57, (ResResSpec)var7_53, (ResValue)var8_58);
                                    try {
                                        v57.addResource((ResResource)var10_74, false);
                                        var7_53.addResource((ResResource)var10_74, false);
                                        continue;
                                    }
                                    catch (AndrolibException var8_59) {
                                        if (this.mKeepBroken) {
                                            this.mType.addResource((ResResource)var10_74, true);
                                            var7_53.addResource((ResResource)var10_74, true);
                                            v58 = new StringBuilder("Duplicate Resource Detected. Ignoring duplicate: ");
                                            v58.append(var10_74);
                                            ARSCDecoder.LOGGER.warning(v58.toString());
                                            continue;
                                        }
                                        throw var8_59;
                                    }
lbl571:
                                    // 1 sources

                                    throw new AndrolibException("Multiple resource specs: " + var11_77);
                                }
                                var3_17 = this.mIn;
                                var4_29 = var3_17.mCountIn.count;
                                var6_42 = this.mHeader.endPosition;
                                if (var4_29 >= var6_42) continue block29;
                                var3_18 = var3_17.skip(var6_42 - var4_29);
                                var5_35 = v59;
                                var5_35("Unknown data detected. Skipping: ");
                                ARSCDecoder.LOGGER.warning(v59.append(var3_18).append(" byte(s)").toString());
                                continue block29;
lbl581:
                                // 1 sources

                                throw new AndrolibException("Config size < 8");
                            }
                            case 512: 
                        }
                        this.mTypeIdOffset = 0;
                        this.checkChunkType(512);
                        var4_23 = this.mIn.mDelegate.readInt();
                        if (var4_23 == 0) {
                            var4_23 = 2;
                            var5_31 = this.mResTable;
                            if (var5_31.mPackageOriginal == null && var5_31.mPackageRenamed == null) {
                                var5_31.mApkInfo.sharedLibrary = var5_36 = true;
                            }
                        }
                        var5_37 = this.mIn.readNullEndedString(128);
                        this.mIn.mDelegate.readInt();
                        this.mIn.mDelegate.readInt();
                        this.mIn.mDelegate.readInt();
                        this.mIn.mDelegate.readInt();
                        if (this.mHeader.headerSize == 288) {
                            this.mTypeIdOffset = this.mIn.mDelegate.readInt();
                        }
                        if (this.mTypeIdOffset > 0) {
                            var3_7.warning("Please report this application to Apktool for a fix: https://github.com/iBotPeaches/Apktool/issues/1728");
                        }
                        this.mHeader.checkForUnreadHeader(this.mIn);
                        this.mTypeNames = StringBlock.readWithChunk(this.mIn);
                        this.mSpecNames = StringBlock.readWithChunk(this.mIn);
                        this.mResId = var4_23 << 24;
                        this.mPkg = var3_7 = v60;
                        var1_1.add(new ResPackage(this.mResTable, var4_23, var5_37));
                        continue;
                    }
                    this.checkChunkType(2);
                    this.mIn.mDelegate.readInt();
                    this.mHeader.checkForUnreadHeader(this.mIn);
                    continue;
                }
                this.checkChunkType(1);
                v61 = this.mHeader;
                var3_19 = v61.startPosition;
                var5_38 = v61.headerSize;
                var6_43 = v61.chunkSize;
                this.mTableStrings = StringBlock.readWithoutChunk(this.mIn, var3_19, var5_38, var6_43);
                continue;
            }
            this.checkChunkType(0);
            this.mHeader.checkForUnreadHeader(this.mIn);
            var3_7.warning("Skipping unknown chunk data of size " + this.mHeader.chunkSize);
            var3_7 = this.mHeader;
            this.mIn.skipBytes(var3_7.chunkSize - var3_7.headerSize);
        }
    }

    public final ResIntBasedValue readValue() {
        Object object;
        if (((ARSCDecoder)object).mIn.mDelegate.readShort() < 8) {
            return null;
        }
        byte by = 0;
        int n = ((ARSCDecoder)object).mIn.mDelegate.readByte();
        if (n == 0) {
            by = ((ARSCDecoder)object).mIn.mDelegate.readByte();
            n = ((ARSCDecoder)object).mIn.mDelegate.readInt();
            if (by == 3) {
                Object object2 = object;
                object = ((ARSCDecoder)object2).mPkg.getValueFactory();
                String string = ((ARSCDecoder)object2).mTableStrings.getHTML(n);
                object.getClass();
                if (string == null) {
                    ResFileValue resFileValue;
                    object = resFileValue;
                    resFileValue = new ResFileValue(n, "");
                } else if (string.startsWith("res/")) {
                    ResFileValue resFileValue;
                    object = resFileValue;
                    resFileValue = new ResFileValue(n, string);
                } else if (!string.startsWith("r/") && !string.startsWith("R/")) {
                    ResStringValue resStringValue;
                    object = resStringValue;
                    resStringValue = new ResStringValue(n, string);
                } else {
                    ResFileValue resFileValue;
                    object = resFileValue;
                    resFileValue = new ResFileValue(n, string);
                }
            } else {
                object = ((ARSCDecoder)object).mPkg.getValueFactory().factory(null, by, n);
            }
            return object;
        }
        object = by;
        Byte by2 = (byte)n;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        objectArray[1] = by2;
        throw new IOException(String.format("Expected: 0x%08x, got: 0x%08x", objectArray2));
    }

    public final String readVariantLengthString(int n) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(16);
        while (true) {
            short s;
            int n2 = n;
            n = n2 + -1;
            if (n2 == 0 || (s = (short)this.mIn.mDelegate.readByte()) == 0) break;
            stringBuilder2.append((char)s);
        }
        this.mIn.skipBytes(n);
        return stringBuilder2.toString();
    }

    public final void checkChunkType(int n) {
        if (((ARSCDecoder)((Object)n2)).mHeader.type == n) {
            return;
        }
        ARSCDecoder aRSCDecoder = n2;
        Integer n2 = n;
        Short s = aRSCDecoder.mHeader.type;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        objectArray[1] = s;
        throw new AndrolibException(String.format("Invalid chunk type: expected=0x%08x, got=0x%08x", objectArray2));
    }
}

