/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.res.decoder.StyledString;
import brut.androlib.res.decoder.StyledString$Span;
import brut.androlib.res.xml.ResXmlEncoders;
import brut.util.ExtDataInput;
import brut.util.ExtDataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Logger;

public final class StringBlock {
    public static final Logger LOGGER = Logger.getLogger(StringBlock.class.getName());
    public static final CharsetDecoder UTF16LE_DECODER = StandardCharsets.UTF_16LE.newDecoder();
    public static final CharsetDecoder UTF8_DECODER = StandardCharsets.UTF_8.newDecoder();
    public static final CharsetDecoder CESU8_DECODER = Charset.forName("CESU8").newDecoder();
    public int[] mStringOffsets;
    public byte[] mStrings;
    public int[] mStyleOffsets;
    public int[] mStyles;
    public boolean mIsUtf8;

    public static StringBlock readWithChunk(ExtDataInput object) {
        ExtDataInput extDataInput = object;
        long l = ((ExtDataInputStream)extDataInput).mCountIn.count;
        short s = 1;
        ExtDataInputStream extDataInputStream = (ExtDataInputStream)extDataInput;
        short s2 = extDataInputStream.mDelegate.readShort();
        if (s2 == s) {
            ExtDataInputStream extDataInputStream2 = extDataInputStream;
            short s3 = extDataInputStream2.mDelegate.readShort();
            return StringBlock.readWithoutChunk((ExtDataInput)object, l, s3, extDataInputStream2.mDelegate.readInt());
        }
        object = s;
        Short s4 = s2;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        objectArray[1] = s4;
        throw new IOException(String.format("Expected: 0x%08x, got: 0x%08x", objectArray2));
    }

    public static StringBlock readWithoutChunk(ExtDataInput extDataInput, long l, int n, int n2) {
        int n3;
        StringBlock stringBlock;
        extDataInput = (ExtDataInputStream)extDataInput;
        int n4 = ((ExtDataInputStream)extDataInput).mDelegate.readInt();
        int n5 = ((ExtDataInputStream)extDataInput).mDelegate.readInt();
        int n6 = ((ExtDataInputStream)extDataInput).mDelegate.readInt();
        int n7 = ((ExtDataInputStream)extDataInput).mDelegate.readInt();
        int n8 = ((ExtDataInputStream)extDataInput).mDelegate.readInt();
        if (n > 28) {
            ((ExtDataInputStream)extDataInput).skipBytes(n - 28);
        }
        StringBlock stringBlock2 = stringBlock;
        stringBlock = new StringBlock();
        n6 = (n6 & 0x100) != 0 ? 1 : 0;
        stringBlock2.mIsUtf8 = n6;
        long l2 = l + (long)n7;
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            long l3 = ((ExtDataInputStream)extDataInput).mCountIn.count;
            if (l3 >= l2) {
                Long l4 = l3;
                Long l5 = l2;
                ExtDataInputStream.LOGGER.warning(String.format("Bad string block: string entry is at %d, past end at %d", l4, l5));
                break;
            }
            nArray[i] = ((ExtDataInputStream)extDataInput).mDelegate.readInt();
        }
        stringBlock2.mStringOffsets = nArray;
        if (n5 != 0) {
            l += (long)n8;
            int[] nArray2 = new int[n5];
            for (int i = 0; i < n5; ++i) {
                l2 = ((ExtDataInputStream)extDataInput).mCountIn.count;
                if (l2 >= l) {
                    Long l6 = l2;
                    Long l7 = l;
                    ExtDataInputStream.LOGGER.warning(String.format("Bad string block: string entry is at %d, past end at %d", l6, l7));
                    break;
                }
                nArray2[i] = ((ExtDataInputStream)extDataInput).mDelegate.readInt();
            }
            stringBlock2.mStyleOffsets = nArray2;
        }
        boolean bl = n8 != 0 && n5 != 0;
        int n9 = n2 - n7;
        if (n5 > 0) {
            n9 = n8 - n7;
        }
        byte[] byArray = new byte[n9];
        stringBlock2.mStrings = byArray;
        ((ExtDataInputStream)extDataInput).mDelegate.readFully(byArray);
        if (bl) {
            n9 = n2 - n8;
            stringBlock2.mStyles = ((ExtDataInputStream)extDataInput).readIntArray(n9 / 4);
        }
        if ((n3 = n9 % 4) >= 1) {
            while (true) {
                int n10 = n3;
                n3 = n10 + -1;
                if (n10 <= 0) break;
                ((ExtDataInputStream)extDataInput).mDelegate.readByte();
            }
        }
        return stringBlock2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getString(int n) {
        String string;
        int n2;
        int n3;
        block18: {
            block16: {
                block15: {
                    CharsetDecoder charsetDecoder;
                    ByteBuffer byteBuffer;
                    int[] nArray;
                    if (n < 0) return null;
                    Object[] objectArray = ((StringBlock)this).mStringOffsets;
                    if (((StringBlock)this).mStringOffsets == null) return null;
                    if (n >= objectArray.length) {
                        return null;
                    }
                    n = objectArray[n];
                    if (((StringBlock)this).mIsUtf8) {
                        objectArray = ((StringBlock)this).mStrings;
                        n = (((StringBlock)this).mStrings[n] & 0x80) != 0 ? (n += 2) : ++n;
                        int n4 = objectArray[n];
                        int n5 = n + 1;
                        if ((n4 & 0x80) != 0) {
                            int n6 = objectArray[n5] & 0xFF;
                            n4 = ((n4 & 0x7F) << 8) + n6;
                            n5 = n + 2;
                        }
                        int[] nArray2 = new int[2];
                        nArray = nArray2;
                        nArray2[0] = n5;
                        nArray2[1] = n4;
                        n3 = nArray2[0];
                    } else {
                        int[] nArray3;
                        int[] nArray4;
                        objectArray = ((StringBlock)this).mStrings;
                        int n7 = (((StringBlock)this).mStrings[n + 1] & 0xFF) << 8 | objectArray[n] & 0xFF;
                        if ((n7 & 0x8000) != 0) {
                            int n8 = objectArray[n + 2] & 0xFF;
                            n7 = (n7 & Short.MAX_VALUE) << 16;
                            n8 = (((objectArray[n + 3] & 0xFF) << 8) + n8 + n7) * 2;
                            int[] nArray5 = new int[2];
                            nArray4 = nArray5;
                            nArray5[0] = 4;
                            nArray5[1] = n8;
                            nArray3 = nArray4;
                        } else {
                            int n9 = n7 * 2;
                            int[] nArray6 = new int[2];
                            nArray4 = nArray6;
                            nArray6[0] = 2;
                            nArray6[1] = n9;
                            nArray3 = nArray4;
                        }
                        n3 = n += nArray3[0];
                        nArray = nArray3;
                    }
                    StringBlock stringBlock = this;
                    n2 = nArray[1];
                    try {
                        byteBuffer = ByteBuffer.wrap(stringBlock.mStrings, n3, n2);
                        if (!stringBlock.mIsUtf8) {
                            charsetDecoder = UTF16LE_DECODER;
                        }
                        charsetDecoder = UTF8_DECODER;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        break block15;
                    }
                    catch (CharacterCodingException characterCodingException) {
                        break block16;
                    }
                    CharsetDecoder charsetDecoder2 = charsetDecoder;
                    string = charsetDecoder2.decode(byteBuffer).toString();
                    return string;
                }
                if (!((StringBlock)this).mIsUtf8) {
                    LOGGER.warning("String extends outside of pool at  " + n3 + " of length " + n2);
                    return null;
                }
                break block18;
            }
            if (!((StringBlock)this).mIsUtf8) {
                LOGGER.warning("Failed to decode a string at offset " + n3 + " of length " + n2);
                return null;
            }
        }
        try {
            string = CESU8_DECODER.decode(ByteBuffer.wrap(((StringBlock)this).mStrings, n3, n2)).toString();
        }
        catch (CharacterCodingException characterCodingException) {
            LOGGER.warning("Failed to decode a string with CESU-8 decoder.");
            return null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public final String getHTML(int var1_1) {
        var2_3 = this.getString(var1_1);
        if (var2_3 == null) {
            return null;
        }
        var3_4 = this.mStyleOffsets;
        if (this.mStyleOffsets == null || this.mStyles == null || var1_1 >= var3_4.length) ** GOTO lbl-1000
        var1_1 = var3_4[var1_1] / 4;
        var3_5 = 0;
        var4_6 = var1_1;
        while (true) {
            var5_7 = this.mStyles;
            if (var4_6 >= this.mStyles.length || var5_7[var4_6] == -1) break;
            ++var3_5;
            ++var4_6;
        }
        if (var3_5 != 0 && var3_5 % 3 == 0) {
            var3_4 = new int[var3_5];
            var4_6 = 0;
            while (true) {
                var5_7 = this.mStyles;
                if (var1_1 < this.mStyles.length && (var5_8 = var5_7[var1_1]) != -1) {
                    var6_10 = var4_6 + 1;
                    ++var1_1;
                    var3_4[var4_6] = var5_8;
                    var4_6 = var6_10;
                    continue;
                }
                break;
            }
        } else lbl-1000:
        // 2 sources

        {
            var3_4 = null;
        }
        if (var3_4 == null) {
            return ResXmlEncoders.escapeXmlChars(var2_3);
        }
        if (var3_4[1] > var2_3.length()) {
            return ResXmlEncoders.escapeXmlChars(var2_3);
        }
        var1_2 = v0;
        v0 = new ArrayList<StyledString$Span>(var3_4.length / 3);
        for (var4_6 = 0; var4_6 < var3_4.length; var4_6 += 3) {
            var5_9 = this.getString(var3_4[var4_6]);
            var6_10 = var3_4[var4_6 + 1];
            var7_11 = var3_4[var4_6 + 2];
            var1_2.add(new StyledString$Span(var5_9, var6_10, var7_11));
        }
        var1_2.sort(null);
        return new StyledString(var2_3, var1_2).toString();
    }
}

