/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.io.StandardLineSeparator;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream$Builder;

public abstract class IOUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static byte[] byteArray() {
        return new byte[8192];
    }

    public static char[] charArray() {
        return new char[8192];
    }

    public static void closeQ(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] toByteArray(InputStream closeable) {
        ThresholdingOutputStream thresholdingOutputStream;
        UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream;
        InputStream inputStream = closeable;
        new UnsynchronizedByteArrayOutputStream$Builder();
        closeable = unsynchronizedByteArrayOutputStream;
        unsynchronizedByteArrayOutputStream = new UnsynchronizedByteArrayOutputStream();
        IOConsumer iOConsumer = object -> {
            object = Integer.MAX_VALUE;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            throw new IllegalArgumentException(String.format("Cannot read more than %,d into a byte array", objectArray2));
        };
        try (ThresholdingOutputStream thresholdingOutputStream2 = thresholdingOutputStream;){
            IOUtils.copy(inputStream, new ThresholdingOutputStream(iOConsumer, arg_0 -> IOUtils.lambda$toByteArray$1((UnsynchronizedByteArrayOutputStream)closeable, arg_0)));
            return ((UnsynchronizedByteArrayOutputStream)closeable).toByteArray();
        }
    }

    public static /* synthetic */ OutputStream lambda$toByteArray$1(UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream, ThresholdingOutputStream thresholdingOutputStream) {
        return unsynchronizedByteArrayOutputStream;
    }

    static {
        System.lineSeparator();
        ((Object)((Object)StandardLineSeparator.LF)).getClass();
        ((Object)((Object)StandardLineSeparator.CRLF)).getClass();
        ThreadLocal.withInitial(IOUtils::byteArray);
        ThreadLocal.withInitial(IOUtils::charArray);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) {
        int n;
        byte[] byArray = new byte[8192];
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
        }
    }
}

