# Meta-Prompt Optimization for LLM-Based Sequential Decision Making

## Requirements

To set up the environment and install all required dependencies, please run the following command:

```bash
pip install -r requirements.txt
```

## Domain Generation

The `domain_generation.ipynb` file provides a brief guide for generating domains required for the experiments. These domains are formatted data with specific requirements and include precomputed values necessary for the subsequent experiments. Please refer to this notebook to understand the domain creation process and ensure the generated data meets the required specifications.

| **Column Name**   | **Content Description**                           |
|:------------------:|:-----------------------------------------:|
| `Z1`              | Task description.                        |
| `Z2`              | Meta-instruction.                        |
| `Merged_Content`  | Combined task description and meta-instruction. |
| `Z1-Z2-Embedding` | Precomputed embedding of the combined content. |


---

## Baselines

This repository includes code to reproduce baseline results. The baselines can be executed as follows:

### BSSCD/BSSND Baseline:
- Run `bsscd_easy.py` for the easy difficulty setting of the BSSCD baseline. Note that this code is also compatible with the BSSND baseline for the same difficulty setting.
- Run `bsscd_hard.py` for the hard difficulty setting of the BSSCD baseline. Similarly, this code can be used for the BSSND baseline under the hard difficulty setting.

### OPRO Baseline:
- Run `linear_regression_opro.py` for the OPRO baseline on the Linear Regression task.
- Run `tsp_opro.py` for the OPRO baseline on the Traveling Salesman Problem (TSP) task.
- Run `instruction_optimization_opro.py` for the OPRO baseline on the Instruction Optimization task.
---

## EXPO and EXPO-ES Algorithm Experiments

Execute the following scripts to implement our **EXPO** and **EXPO-ES** algorithms across various tasks and experimental settings:

### BSSCD/BSSND Experiments:
The following scripts can be used to implement the EXPO and EXPO-ES algorithms for both BSSCD and BSSND tasks, with easy and hard difficulty settings:

- `bsscd_easy_expo.py`: EXPO algorithm on the easy difficulty.
- `bsscd_easy_expo_es.py`: EXPO-ES algorithm on the easy difficulty.
- `bsscd_hard_expo.py`: EXPO algorithm on the hard difficulty.
- `bsscd_hard_expo_es.py`: EXPO-ES algorithm on the hard difficulty.

### Linear Regression Experiments:
- `linear_regression_expo.py` for the EXPO algorithm on the Linear Regression task.
- `linear_regression_expo_es.py` for the EXPO-ES algorithm on the Linear Regression task.

### TSP Experiments:
- `tsp_expo.py` for the EXPO algorithm on the Traveling Salesman Problem (TSP).
- `tsp_expo_es.py` for the EXPO-ES algorithm on the Traveling Salesman Problem (TSP).

### Instruction Optimization Experiments:
- `instruction_optimization_expo.py` for the EXPO algorithm on the Instruction Optimization task.
- `instruction_optimization_expo_es.py` for the EXPO-ES algorithm on the Instruction Optimization task.