#include <iostream>
#include <random>
#include <time.h>
using namespace std;
int const N=31000,D=5;
int n,d,k,J;
int b[N];
double a[N][D],c[D][D],s[N],pre_sum[N],tt[N],sum[D][D];
int binary_search(double v){
	int l=1,r=n;
	while (r-l>1){
		int mid=(l+r)/2;
		if (pre_sum[mid]>=v) r=mid; else l=mid+1;
	}
	if (pre_sum[l]>=v) return l;
	if (pre_sum[r]>=v) return r;
}
int get(){
	pre_sum[0]=0;
	for (int i=1;i<=n;i++)
		pre_sum[i]=pre_sum[i-1]+s[i];
	double r=1.0*rand();
	r=r/32767;
	r=r*pre_sum[n];
	return binary_search(r);
}
double dis(int x, int y){
	double r=0;
	for (int l=1;l<=d;l++)
		r+=(c[y][l]-a[x][l])*(c[y][l]-a[x][l]);
	return r;
}
void init(){
	for (int i=1;i<=n;i++) s[i]=1;
	for (int i=1;i<=k;i++){
		int t=get();
		for (int j=1;j<=d;j++)
			c[i][j]=a[t][j];
		for (int l=1;l<=n;l++){
			double r=dis(l,i);
			if (i==1 || r<s[l]) s[l]=r;
		}
	}
	return;
}
void Estep(){
	for (int i=1;i<=n;i++){
		b[i]=1;
		for (int j=2;j<=k;j++)
			if (dis(i,j)<dis(i,b[i])) b[i]=j;
	}
	return;
}
void Mstep(){
	for (int i=1;i<=k;i++) tt[i]=0;
	for (int i=1;i<=k;i++)
		for (int j=1;j<=d;j++)
			sum[i][j]=0;
	for (int i=1;i<=n;i++){
		tt[b[i]]++;
		for (int j=1;j<=d;j++)
			sum[b[i]][j]+=a[i][j];
	}
	for (int i=1;i<=k;i++)
		if (tt[i]>0)
		for (int j=1;j<=d;j++)
			c[i][j]=sum[i][j]/tt[i];
	return;
}
void compute_sensitivity(){
	Estep();
	double tot=0;
	for (int i=1;i<=k;i++) tt[i]=0;
	for (int i=1;i<=n;i++){
		tt[b[i]]=tt[b[i]]+1;
		tot+=dis(i,b[i]);
	}
	for (int i=1;i<=n;i++)
		s[i]=dis(i,b[i])/tot+1/tt[b[i]];
}
void lloyd(){
	for (int T=1;T<100;T++){
		Estep();
		Mstep();
	}
	return;
}
int main(){
	srand((int)time(0));
	freopen("russian.in","r",stdin);
	freopen("sensitivity1.in","w",stdout);
	cin>>n>>d>>k>>J;
	for (int i=1;i<=n;i++)
		for (int j=1;j<=d;j++){
			cin>>a[i][j];
			if(a[i][j]==-1) a[i][j]=rand()%2000; 
		}
	init();
	lloyd();
	compute_sensitivity();
	cout<<n<<endl;
	for (int i=1;i<=n;i++)
		cout<<s[i]<<endl;
	return 0;
} 
