#include <iostream>
#include <cmath>
#include <time.h>
using namespace std;
int const N=100001,D=101,TRound=20,m=800;
int n,k,d,J,a[N][D],c[D][D],coreset[N],u[N];
double W,weight[N],dis1,dis2,dis3,dist[N],acr1,acr2,eps1,eps2,s[N],pre_sum[N];
void gen_center(){
	int seed=rand()%1;
	if (seed==0){
		for (int i=1;i<=k;i++)
			for (int j=1;j<=d;j++){
				if (j==1) c[i][j]=rand()%50;
				if (j==2) c[i][j]=rand()%50;
				if (j==3) c[i][j]=rand()%1000;
			}
	}
	if (seed==1){
		for (int i=1;i<=k;i++)
			for (int j=1;j<=d;j++){
				if (j==1) c[i][j]=rand()%100+900;
				if (j==2) c[i][j]=rand()%100+900;
				if (j==3) c[i][j]=500;
			}
	}
}

int binary_search(double v){
	int l=1,r=n;
	while (r-l>1){
		int mid=(l+r)/2;
		if (pre_sum[mid]>=v) r=mid; else l=mid+1;
	}
	if (pre_sum[l]>=v) return l;
	if (pre_sum[r]>=v) return r;
}

void importance_sampling(){
	pre_sum[0]=0;
	for (int i=1;i<=n;i++)
		pre_sum[i]=pre_sum[i-1]+s[i];
	W=0;
	for (int i=1;i<=m;i++){
		double r=1.0*rand();
		r=r/32767;
		r=r*pre_sum[n];
		coreset[i]=binary_search(r);
		weight[i]=pre_sum[n]/s[coreset[i]]/double(m);
		W+=weight[i];
	}
	for (int i=1;i<=m;i++)
		weight[i]=weight[i]/W*n;
}
void uniform_sampling(){
	for (int i=1;i<=m;i++)
		u[i]=rand()%n+1;
}
int main(){
	srand((int)time(0));
	freopen("mushroom.txt","r",stdin);
	cin>>n>>d>>k>>J;
	for (int i=1;i<=n;i++)
		for (int j=1;j<=d;j++)
			cin>>a[i][j];
	freopen("sensitivity.in","r",stdin);
	cin>>n;
	for (int i=1;i<=n;i++)
		cin>>s[i];
	cout<<"Number of Data Points = "<<n<<endl;
	cout<<"Number of Coreset Points = "<<m<<endl;
	cout<<"CoresetACR vs UniformACR"<<endl;
	for (int round=1;round<=TRound;round++){
		importance_sampling();
		acr1=acr2=0;
		for (int T=1;T<=150;T++){
			gen_center();
			uniform_sampling();
			dis1=0;
			dis2=0;
			dis3=0;
			for (int i=1;i<=n;i++)	{
				dist[i]=1e9;
				for (int t=1;t<=k;t++){
					double now=0;
					for (int j=1;j<=d;j++)
						if (a[i][j]!=-1) now=now+(a[i][j]-c[t][j])*(a[i][j]-c[t][j]);
					if (now<dist[i]) dist[i]=now;
				}
				dis1+=dist[i];
			}
			for (int i=1;i<=m;i++)
				dis2+=weight[i]*dist[coreset[i]];
			for (int i=1;i<=m;i++)
				dis3+=dist[u[i]]*(double)n/(double)m;
			acr1=max(acr1,fabs(dis1-dis2)/dis1);
			acr2=max(acr2,fabs(dis1-dis3)/dis1);
		}
		eps1+=acr1/TRound;
		eps2+=acr2/TRound;
	}
	cout<<eps1*100<<"%"<<" vs ";
	cout<<eps2*100<<"%"<<endl;
	return 0;
}
