#include <iostream>
#include <stdio.h>
#include <random>
#include <time.h>
#include <cmath>
using namespace std;
int const N=410000,D=5,TT=6;
int n,m=1500,k,d,J,p[N],b[N];
double a[N][D],c[D][D],weight[N],s[N],pre_sum[N],W,mean[N],total[D],tt[D][D],sum[D][D],cost,ans;
double dis(int x, int y){
	double r=0;
	for (int l=1;l<=d;l++)
		if (a[p[x]][l]!=-1) r+=(c[y][l]-a[p[x]][l])*(c[y][l]-a[p[x]][l]);
	return r;
}
void Estep(){
	for (int i=1;i<=m;i++){
		b[i]=1;
		for (int j=2;j<=k;j++)
			if (dis(i,j)<dis(i,b[i])) b[i]=j;
	}
}
void Mstep(){
	for (int i=1;i<=k;i++)
		for (int j=1;j<=d;j++){
			tt[i][j]=0;
			sum[i][j]=0;
		}
	for (int i=1;i<=m;i++)
		for (int j=1;j<=d;j++)
			if (a[p[i]][j]!=-1){
				tt[b[i]][j]+=weight[i];
				sum[b[i]][j]+=a[p[i]][j]*weight[i];
			}
	for (int i=1;i<=k;i++)
		for (int j=1;j<=d;j++)
			if (tt[i][j]>0) c[i][j]=sum[i][j]/tt[i][j];
}
void lloyd(){
	for (int i=1;i<=k;i++)
		for (int j=1;j<=d;j++)
			c[i][j]=mean[j]-300+rand()%600;
	for (int T=1;T<1000;T++){
		Estep();
		Mstep();
	}
}
void rawdata(){
	m=n;
	for (int i=1;i<=n;i++){
		p[i]=i;
		weight[i]=1;
	}
}

int binary_search(double v){
	int l=1,r=n;
	while (r-l>1){
		int mid=(l+r)/2;
		if (pre_sum[mid]>=v) r=mid; else l=mid+1;
	}
	if (pre_sum[l]>=v) return l;
	if (pre_sum[r]>=v) return r;
}

int gen(){
	int x=(rand()%10000)*32767+rand();
	return x;
}

void importance_sampling(){
	W=0;
	for (int i=1;i<=m;i++){
		double r=1.0*(gen()%1000001);
		r=r/1000000;
		r=r*pre_sum[n];
		p[i]=binary_search(r);
		weight[i]=pre_sum[n]/s[p[i]]/double(m);
		W+=weight[i];
	}
	for (int i=1;i<=m;i++)
		weight[i]=weight[i]/W*n;
}

void evaluate(){
	Estep();
	ans=0;
	for (int i=1;i<=m;i++)
		for (int j=1;j<=d;j++)
			if (a[p[i]][j]!=-1) ans=ans+(c[b[i]][j]-a[p[i]][j])*(c[b[i]][j]-a[p[i]][j])*weight[i];
}
int main(){
	srand(time(0));
	freopen("cubes.in","r",stdin);
	cin>>n>>d>>k>>J;
	k=2;
	for (int i=1;i<=n;i++)
		for (int j=1;j<=d;j++){
			cin>>a[i][j];
			if (a[i][j]!=-1){
				mean[j]+=a[i][j];
				total[j]++;
			}
		}
	for (int j=1;j<=d;j++) mean[j]=mean[j]/total[j];
	rawdata();
	lloyd();
	evaluate();
	cost=ans;
	printf("%.6lf\n",cost);
	freopen("sensitivity.in","r",stdin);
	cin>>n;
	for (int i=1;i<=n;i++)
		cin>>s[i];
	pre_sum[0]=0;
	for (int i=1;i<=n;i++)
		pre_sum[i]=pre_sum[i-1]+s[i];
	freopen("Lloyd_Coreset.out","w",stdout);
	for (m=500;m<=5000;m+=500){
		double err=0;
		for (int w=1;w<=20;w++){
			importance_sampling();
			lloyd();
			evaluate();
			err+=fabs(cost-ans)/cost;
		}
		err=err/20;
		printf("Coreset Size = %d ,",m);
		printf("Relative Error = %.4lf\n",err);
	}
}
