function out = intervalUntil(lhsInt,untilInt,rhsInt)
% intervalUntil - compute the until combination of two signals given their positive intervals
%
% Syntax:
%    out = intervalUntil(lhsInt,untilInt,rhsInt)
%
% Inputs:
%    lhsInt - positive intervals of the left-hand side signal
%    untilInt - time interval of the until operator
%    rhsInt - positive intervals of the right-hand side signal
%
% Outputs:
%    out - the combined signal
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Florian Lercher
% Written:       12-February-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% set output to false by default
out = pointSegmentSignal.indicator(stlInterval(0,inf),false,false);

if untilInt.contains(0)
    [ub,rc] = supremum(untilInt);
    untilIntNoZero = stlInterval(0,ub,false,rc);
else
    untilIntNoZero = untilInt;
end
for i=1:length(lhsInt)
    for j=1:length(rhsInt)
        posShift = ((rhsInt(j) & rightClosure(lhsInt(i))) - untilIntNoZero) & leftClosure(lhsInt(i));

        if ~representsa(posShift,'emptySet')
            out = out.set(posShift,true);
        end
    end
end

% if 0 delay is allowed, then until is true where rhs is true
% regardless of lhs (since we use the strict semantics)
if untilInt.contains(0)
    for j=1:length(rhsInt)
        out = out.set(rhsInt(j),true);
    end
end

% ------------------------------ END OF CODE ------------------------------
