function res = test_kleene
% test_kleene - unit test function of kleene
%
% Syntax:
%    res = test_kleene
%
% Inputs:
%    -
%
% Outputs:
%    res - boolean
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Benedikt Seidl
% Written:       10-August-2022
% Last update:   21-February-2024 (FL, add tests for fromBool and array operators)
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

res = [];

% conjunction
res(end+1,1) = isequal(kleene.True, kleene.True & kleene.True);
res(end+1,1) = isequal(kleene.False, kleene.True & kleene.False);
res(end+1,1) = isequal(kleene.Unknown, kleene.True & kleene.Unknown);
res(end+1,1) = isequal(kleene.False, kleene.False & kleene.True);
res(end+1,1) = isequal(kleene.False, kleene.False & kleene.False);
res(end+1,1) = isequal(kleene.False, kleene.False & kleene.Unknown);
res(end+1,1) = isequal(kleene.Unknown, kleene.Unknown & kleene.True);
res(end+1,1) = isequal(kleene.False, kleene.Unknown & kleene.False);
res(end+1,1) = isequal(kleene.Unknown, kleene.Unknown & kleene.Unknown);

% disjunction
res(end+1,1) = isequal(kleene.True, kleene.True | kleene.True);
res(end+1,1) = isequal(kleene.True, kleene.True | kleene.False);
res(end+1,1) = isequal(kleene.True, kleene.True | kleene.Unknown);
res(end+1,1) = isequal(kleene.True, kleene.False | kleene.True);
res(end+1,1) = isequal(kleene.False, kleene.False | kleene.False);
res(end+1,1) = isequal(kleene.Unknown, kleene.False | kleene.Unknown);
res(end+1,1) = isequal(kleene.True, kleene.Unknown | kleene.True);
res(end+1,1) = isequal(kleene.Unknown, kleene.Unknown | kleene.False);
res(end+1,1) = isequal(kleene.Unknown, kleene.Unknown | kleene.Unknown);

% negation
res(end+1,1) = isequal(kleene.False, ~ kleene.True);
res(end+1,1) = isequal(kleene.True, ~ kleene.False);
res(end+1,1) = isequal(kleene.Unknown, ~ kleene.Unknown);

% fromBool
res(end+1,1) = isequal(kleene.True, kleene.fromBool(true));
res(end+1,1) = isequal(kleene.False, kleene.fromBool(false));

% arrays
arr1 = [kleene.True, kleene.False, kleene.Unknown];
arr2 = [kleene.Unknown, kleene.False, kleene.True];
res(end+1,1) = isequal([kleene.Unknown, kleene.False, kleene.Unknown], arr1 & arr2);
res(end+1,1) = isequal([kleene.True, kleene.False, kleene.True], arr1 | arr2);
res(end+1,1) = isequal([kleene.False, kleene.True, kleene.Unknown], ~arr1);

% combine results
res = all(res);

% ------------------------------ END OF CODE ------------------------------
