function data = xai_readData(dataset,datapath)
% prepares the dataset for further usage

fprintf('Loading data: ''%s''..\n', dataset)

data = struct;

switch dataset
    case 'MNIST'
        % load data
        load([datapath filesep 'MNIST/mnist.mat'],'testX','testY')

        % save data
        data.X = double(testX) / 255;
        data.Y = double(testY+1);
        data.path = [datapath filesep 'MNIST'];
        data.inputSize = [28,28,1];

    case 'GTSRB'
        % read raw data
        filetext = fileread([datapath filesep 'GTSRB/test.csv']);
        data_raw = split(filetext,{newline,','});
        data_raw = data_raw(1:end-1); % remove empty line at the end
        data_raw = reshape(data_raw, 2, [])';
        data_raw = data_raw(2:end,:); % remove header

        % save data
        data.X = data_raw(:,1);
        data.Y = cell2mat(cellfun(@(label) str2double(label)+1, data_raw(:,2), 'UniformOutput', false));
        data.path = [datapath filesep 'GTSRB'];
        data.inputSize = [32,32,3];

    case 'CIFAR'
        cifar10Data = tempdir;
        url = 'https://www.cs.toronto.edu/~kriz/cifar-10-matlab.tar.gz';
        helperCIFAR10Data.download(url,cifar10Data);
        [~,~,testImages,testLabels] = helperCIFAR10Data.load(cifar10Data);
        data.X = double(testImages);
        data.Y = double(testLabels);
        data.inputSize = [32,32,3];

    otherwise
        throw(CORAerror('CORA:configFile',sprintf('Unknown data set: %s', dataset)))
end

end