function pZ = empty(n)
% empty - instantiates an empty polynomial zonotope
%
% Syntax:
%    pZ = polyZonotope.empty(n)
%
% Inputs:
%    n - dimension
%
% Outputs:
%    pZ - empty polynomial zonotope
%
% Example: 
%    pZ = polyZonotope.empty(2);
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: none

% Authors:       Mark Wetzlinger
% Written:       09-January-2024
% Last update:   15-January-2024 (TL, parse input)
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% parse input
if nargin == 0
    n = 0;
end
inputArgsCheck({{n,'att','numeric',{'scalar','nonnegative'}}});

pZ = polyZonotope(zeros(n,0));

% ------------------------------ END OF CODE ------------------------------
